/*
**   Dynamic Evaluation of Job Search Training 
**
**  Purpose:
**    Dynamic Treatment Effect Propensity Score Methods
**    Propensity Score Matching Methods to Estimate Dynamic Treatment Effect
**
**  Possible Estimates:
**    - Estimation of mean for single and multiple treatment
**    - Estimation of Standard Errors and 95% Confidence intervals using subsampling
**    - Estimates for g-computation Logit method
**
**  Note: in order to obatain estimates using different units of time (Table 3 top panel)
**        must adjust lines 475 and 476 to have d=15 or 60 and dd=15 or 60
**    
**  Date:
**    01/06/15
**
**  Author:
**   Stephen Kastoryano
*/
#include <oxstd.h> // include the Ox standard library header
#include <oxfloat.h>
#include <oxprob.h>
#include <oxdraw.h>
//#include <packages/gnudraw/gnudraw.h>
#import <maximize>

decl dat,datP;

kernmatch(const propscore)	 // Propensity Score Matching on Nearest Neighbour
{
	decl x,x1,x2, dat1, dat2, i, d;
	decl propscoreMU, propscoreSD,bw,k,dat2T,cal,w;
	
	propscoreMU =sumc(propscore)/sizer(propscore);	       //mean propscore
	//propscoreSD = (sumc((propscore-propscoreMU).^2)).^(0.5)/sizer(propscore); //standard deviation propscore
	//println("propscoreSD  = ",propscoreSD);
	bw=0.005; 	  //bandwidth for Kernel	 //Baseline chosen as bw=0.005;
	cal=0.025;        //caliper for neighborhood of matching	//Baseline chosen as cal=0.025;
	
	x = dat~propscore;	   //dat[][14]=propscore
	dat1 = selectifr(x,(x[][sizec(x)-2] .== 1));
	dat2 = selectifr(x,(x[][sizec(x)-2] .== 0));

	x=<>;
	x1 = <>;
	x2 = <>;

	for(i=0;i<rows(dat1);++i) //rows(dat1)
	{
	    // d limits the Kernel to match within [pscoreT-pscoreSD;pscoreT+pscoreSD]
		d = (dat2[][sizec(dat1)-1] .>= dat1[i][sizec(dat1)-1]- cal).*(dat2[][sizec(dat1)-1] .<= dat1[i][sizec(dat1)-1]+ cal);
		//k =	 d.*(1-(fabs(dat2[][sizec(dat1)-1]-dat1[i][sizec(dat1)-1])./bw));     //Triangular Kernel
		//k =	 d.*((3/4).*(1-(fabs(dat2[][sizec(dat1)-1]-dat1[i][sizec(dat1)-1])./bw).^2));     //Epanechnikov Kernel
		k = d.*(exp(-0.5*(fabs(dat2[][sizec(dat1)-1]-dat1[i][sizec(dat1)-1])/bw).^2)/(sqrt(M_2PI)));	  //Gaussian Kernel

		if (sumc(d) ==0)
		{x1 = x1;
		}
		else
		{x1 = x1 | selectifr(dat1[i][],sizer(selectifr(d,d.>0))>0)~i;
		}
		w=k./sumc(k);
		dat2T=dat2~i~w;
				
	//	exit[-1];
		x2 = x2|selectifr(dat2T,d.==1);
	}
	x1=x1~1~1;
	x2=x2~0;
	x=x1|x2;

	
	return x;	// Return X matrix of Control Group 
}
  
  
match(const propscore)	 // Propensity Score Matching on Nearest Neighbour
{
	decl x, dat1, dat2, i, d,d2;

	x = dat~propscore;
	dat1 = selectifr(x,(x[][sizec(x)-2] .== 1));
	dat2 = selectifr(x,(x[][sizec(x)-2] .== 0));	  

	x = <>;
	
	for(i=0;i<rows(dat1);++i)
	{	    
		d = (dat2[][sizec(dat1)-1] - dat1[i][sizec(dat1)-1]).^2;		
		d = (d .== min(d));
		d2=selectifr(dat2,d);
		if (sizer(selectifr(dat2,d)) .==1)
		d2=d2;
		else
		d2=d2[0][];		// if more than 1 minimum, choose first

		x = x|d2;
	}
	 
	return x;	// Return X matrix of Control Group 
}
 
  
likelihoodTreat(const param, const loglik, const score, const hessian)	 // Likelihood Estimation of Logit Model for Treatment
{
	decl xb, logl, vWeight;

	vWeight=dat[][4+rows(param)+1] ;
	xb = exp(dat[][4:4+rows(param)-1]*param);
	
	logl =  log(vWeight) + dat[][4+rows(param)] .* log(xb) - log(1+xb);		  //   dat[][4+rows(param)] is treatment indic.
	// If vWeight not equal 1 then this is weighted likelihood of logit
	loglik[0] = meanc(logl);

	return 1;
}


SurvContr(const S, const T, const dd,const t,const S2)
{
	decl  h1, h2, delta,S1P,S2P,VS1, VS2, Vdelta,pExit,dat1P,dat2P,par;
		
	S2P=S2;				
	dat2P=datP ;	//Data Control
	
	if (dat2P ==<>)
	break;
			
	if (sumc(dat2P[][sizec(dat2P)-2])==0)		   // dat2P[][sizec(dat2P)-2] is exit indic
	{h2=0;
	}
	else
	{h2 = sumc(dat2P[][sizec(dat2P)-3] .*(1-dat2P[][sizec(dat2P)-1]).*dat2P[][sizec(dat2P)-2]) / sumc(dat2P[][sizec(dat2P)-3].*(dat2P[][0] .>= t));
	 // datP[][sizec(dat2P)-1] is ex-post treatment prob.	so (1-dat2P[][sizec(dat2P)-1]) is prob.	ex-post treatment is 0
	 // datP[][sizec(dat2P)-3] is matching weight
	}				
	S2P = S2P .* (1-h2);   

	return S2P~sizer(dat2P); 
}

SurvTreat(const S, const T, const dd,const t,const S1)
{
	decl  h1, h2, delta,S1P,S2P,VS1, VS2, Vdelta,pExit,dat1P,dat2P,par,green1;
		 
	S1P=S1;
	dat1P=datP ;	  //Data Treated
		
	if (dat1P ==<>)
	break;
			
	//Generating subinterval hazards
	if 	 (sumc(dat1P[][sizec(dat1P)-1] )==0)	   // dat1P[][sizec(dat2P)-1] is exit indic
	{h1=0;
	}
	else
	{h1 = sumc(dat1P[][sizec(dat1P)-1]) / sumc(dat1P[][0] .>= t);		
	}
	S1P = S1P .* (1-h1);

	return S1P~sizer(dat1P); 
}


calceffect(const mDur, const mX,const mins,const maxs,const dT,const d,const dd,const B,const iSub,const iMatchmeth)
{
	decl dat00,vT,vY0T,vY0TSubSD,vY1T,vY1TSubSD,vDelta,vDeltaSD,mDeltaSubCI,vDeltaSubMu,vDeltaSubSD,s,S,T,dat0,obs,sub;
	decl vDeltaSub,	vY0TSub,vY1TSub,vVDeltaSub,vVY0TSub,vVY1TSub,b,vB,select,i,k,dat1,dat2;
	decl iNbrTreat,iNbrCont,param0,param,function,propscore,propscore2,S1,S2,vsurv1,vsurv2,obsdat1,obsdat2,t;
	decl datn,dat1n,dat2n, propscoreP,obs1,obs2,delta,paramlag;
	decl effects,Y0TSubVar,Y1TSubVar,DeltaSubVar,Y0TSubSD,Y1TSubSD,DeltaSubSD;
		
	dat00 = mDur~mX;

			
	vT=zeros(maxs-mins,1);
	vY0T=zeros(maxs-mins,1);
	vY0TSubSD=zeros(maxs-mins,1);
	vY1T=zeros(maxs-mins,1);
	vY1TSubSD=zeros(maxs-mins,1);
	vDelta=zeros(maxs-mins,1);		  // Vector containing treatment effect estimates for each period 
	vDeltaSubSD=zeros(maxs-mins,1);
	mDeltaSubCI=zeros(maxs-mins,2);	  // Matrix containing lower and upper bound for 95% CI estimates
	vDeltaSubMu=zeros(maxs-mins,1);
	
	
	for(s=mins; s<maxs; ++s)
	{
		S = s;			   // start of treatment interval. 
		T = s+dT;		   // end of treatment interval.
		dat0 = selectifr(dat00,(dat00[][0] .>= S+d));		 //For subsampling	 Sample all people who exited after S+d
		dat0 = selectifr(dat0,(dat0[][2] .>= S));	   // Sample all people who entered training after S		
		
		obs=rows(dat0);					   // Number of Observations
		sub=round(obs^(iSub/100));	 // Number of observations for each subsample, rounded to nearest integer
	    vDeltaSub=zeros(B,1);
		vY0TSub=zeros(B,1);
		vY1TSub=zeros(B,1);
		vVDeltaSub=zeros(B,1);
		vVY0TSub=zeros(B,1);
		vVY1TSub=zeros(B,1);
	
	    b=-1;
	    while(b<B)
	    {
			
			if (b!=-1)
			{
        		vB=ransubsample(obs,obs)';		  //Generating new random subsample for each b
	    		vB=	ranshuffle(sub,vB)';
    			vB=sortc(vB);
	    		select=zeros(obs,1);
	    		for(i=0; i<sub; ++i)
	    		{
	    			k=vB[i];
	    			select[k]=1;	  
	    		}	  
	    		dat = selectifr(dat0,(select .== 1));
			}
			else
			{
				dat =  dat0;
			}
			
			

			// For TREATED population in matching
			dat1 = selectifr(dat,dat[][3].*(dat[][2] .< S+d));	 // Treatment group= Sample of people treated in [S,d)
			dat1 = dat1~ones(rows(dat1),1);	


			//***For CONTROL population in matching*******
			dat2 = selectifr(dat,(1-dat[][3].*(dat[][2] .< S+d)));  // For Sianesi, F&J and Logit method   Control sample in [S,d)
			dat2 = dat2~zeros(rows(dat2),1);
			
			dat = dat1|dat2;

			if (b!=-1)
			{
				//println("b ", b);
				//println("b, Subsampled, Number of treated Sub, Number of controls Sub ", b~rows(dat)~rows(dat1)~rows(dat2));
			}
			else
			{
				iNbrTreat=rows(dat1);
				iNbrCont=rows(dat2);				
			}
			//********************************************
			param0 = zeros(sizec(mX),1);		 		
			param = param0;	 // Initialising Treatment parameters. 1 for each expl. variable
			//MaxControl(-1,1);
			dat = dat~1; 	 // Columns of ones redundant here (necessary for matching weights later)
			MaxBFGS(likelihoodTreat, &param, &function, 0, 1);
			dat = dat[][0:sizec(dat)-2]	;
			// Generate propensity score  (without above 50 exclusion restr.)
			propscore = exp(dat[][sizec(mDur):sizec(mDur)+ rows(param)-1]*param)./(1+exp(dat[][sizec(mDur):sizec(mDur)+ rows(param)-1]*param));  
			//println(minc(propscore)~maxc(propscore));
			//println("propscore~dat[][13] = ",propscore~dat[][13]);
			//exit[-1];

			if 	 (iMatchmeth ==0)		  //Match control group Neighborhoud Kernel
			{	
				dat = kernmatch(propscore);		 //Matching based on Neighbourhood Kernel
				dat1= selectifr(dat,dat[][sizec(dat)-1].==1);	 //Required for Matching based on Neighbourhood Kernel
				dat2= selectifr(dat,dat[][sizec(dat)-1].==0);	 //Required for Matching based on Neighbourhood Kernel	
				dat1 =dat1[][0:sizec(dat0)]~dat1[][sizec(dat0)+3];		//Required for Matching based on Neighbourhood Kernel 
				dat2 =dat2[][0:sizec(dat0)]~dat2[][sizec(dat0)+3];		//Required for Matching based on Neighbourhood Kernel
				//	~dat1[][sizec(dat0)] is treatment indic., ~dat2[][sizec(dat0)+3] is matching weight 
			}
			else if (iMatchmeth ==1)	 //Match control group Nearest Neighbour
			{				
				dat2 = match(propscore);		   //Matching based on Nearest Neighbour
				dat1 =dat1[][0:sizec(dat0)]~ones(sizer(dat1),1);			   //For NN
				dat2 =dat2[][0:sizec(dat0)]~ones(sizer(dat2),1);			   //For NN
			}
			else						//Match control group propensity score weighting
			{
				propscore2=	selectifr(propscore,dat[][sizec(dat)-1].==0);
				dat1 =dat1[][0:sizec(dat0)]~ones(sizer(dat1),1);			   //For Propensity weighting
				dat2 =dat2[][0:sizec(dat0)]~(propscore2./(1-propscore2));			   //For Propensity weighting 
			}
			
			dat=dat1|dat2;
			
	 		 /*	 */
			S1 = 1;
		    S2 = 1;
			obsdat1=sizer(dat1);
			obsdat2=sizer(dat2);
			paramlag=zeros(sizec(mX),1);
		 	/************Logit method **************/
		 
			for(t=S+d;t<T;t=t+dd)	   //Estimating survival based on subintervals [t,d) within [S,T)
			{

	   			datn=selectifr(dat,(dat[][0] .>= t) -(1-dat[][1]).*(dat[][0] .>= t).*(dat[][0] .< t+dd)) ;	  //remove random right censored in interval
				dat =selectifr(dat,(dat[][0] .>= t) -(1-dat[][1]).*(dat[][0] .>= t).*(dat[][0] .< t+dd)) ;
				dat1n= selectifr(dat,dat[][sizec(dat0)]) ;		 //	dat[][sizec(dat0)] is treatment indic.
				dat2n= selectifr(dat,(1-dat[][sizec(dat0)])) ;
		
				
				/*** For Logit only ***/
				//For S1
				dat1=dat1n;
				dat=dat1;														   
				datP= dat~dat[][1].* (dat[][0] .>= t) .* (dat[][0] .< t+dd);		
				vsurv1=SurvTreat(S,T,dd,t,S1);
				S1=vsurv1[0];
				obs1=vsurv1[1];
			
				//For S2
				dat2=dat2n;
				dat2= selectifr(dat2,(1-dat2[][3].*(dat2[][2] .< t-d))) ;
		
				if (T-S-d == d)
				{	 
					dat2= dat2[][0:sizec(dat0)+1]~dat2[][1].* (dat2[][0] .>= t) .* (dat2[][0] .< t+dd)~0 ; 		
				}
				else if ((S+d == t).*(dd ==d))
				{	
					dat2= dat2[][0:sizec(dat0)+1]~dat2[][1].* (dat2[][0] .>= t) .* (dat2[][0] .< t+dd)~0 ;  
				}
				else 
				{	
					dat2= dat2[][0:sizec(dat0)-1]~ dat2[][3].*(dat2[][2] .< t+dd-d) .*(dat2[][2] .>= t-d)~dat2[][sizec(dat0)+1] ; //dat2[][sizec(dat0)+1] is matching weight 
					param = param0;		 // Initialising Ex-post treatment parameters
					dat=dat2;
					MaxBFGS(likelihoodTreat, &param, &function, 0, 1);
					if ((param !=param0).*(param .== .NaN))
					{
						param=paramlag;	
					}
					else if ((paramlag ==param0).*(param .== .NaN))
					{
						param=param0;	
					}
					else
					{
					}
					// Generate ex-post probability treatment
					propscoreP = exp(dat2[][sizec(mDur):sizec(mDur)+ rows(param)-1]*param)./(1+exp(dat2[][sizec(mDur):sizec(mDur)+ rows(param)-1]*param));
					//println("propscoreP = ",propscoreP);
					dat2=dat2~dat2[][1].* (dat2[][0] .>= t) .* (dat2[][0] .< t+dd)~ propscoreP; //dat2[][sizec(dat2)]=exit indic., dat2[][sizec(dat2)+1]=propscoreP
					dat2=selectifr(dat2,(1-dat2[][3].*(dat2[][2] .< t+dd-d).*(dat2[][0]-dat2[][2] .>=d))) ;	   // Do not drop indiv. who exit within d days of treatment
				}
				datP=dat2;
	   
				vsurv2=SurvContr(S,T,dd,t,S2);
				S2=vsurv2[0];
				obs2=vsurv2[1];
			
				//println("S1~S2 = ",S1~S2);
				delta = (S2-S1);	   //Treatment effect
				
	  		   
	 			dat=datn;
				paramlag=param;

			}


			//println("sizer(dat1)    sizer(dat2) =", sizer(dat1)~sizer(dat2));
			//println("Y01   Y11  delta = ", (1-S2)~(1-S1)~delta);
			//println((1-S2)|0|(1-S1)|0|delta|0);	 
			if 	 (b!=-1)
			{
				vY0TSub[b]=(1-S2);	  // Vector of Subsampling Prob Exit for Control at T
				vY1TSub[b]=(1-S1);	  // Vector of Subsampling Prob Exit for Treated at T
	 			vDeltaSub[b]=delta;	  // Vector of Subsampling Prob Exit Treatment Effects

	 			b=b + (vDeltaSub[b] != .NaN)*(vY0TSub[b] != .NaN)*(vY1TSub[b] != .NaN);
	 		}
			else
			{
				savemat("effectsLogit.xls",(1-S2)~(1-S1)~delta);
				vT[s-mins]=s;
				vY0T[s-mins]=(1-S2);
				vY1T[s-mins]=(1-S1);
				vDelta[s-mins]=delta;
				b=b+1;
			}
			
			
	 	}	  		  

	 	//Subsampling Treatment 'Means'
	 	effects = loadmat("effectsLogit.xls");	 
	 	//Subsampling Treatment Variances	& standard errors
	 	Y0TSubVar =sumc((vY0TSub-effects[0]).^2)/sizer(vY0TSub);
	 	Y1TSubVar =sumc((vY1TSub-effects[1]).^2)/sizer(vY1TSub);
	 	DeltaSubVar=sumc((vDeltaSub-effects[2]).^2)/sizer(vDeltaSub);
		Y0TSubSD=sqrt(Y0TSubVar);
		Y1TSubSD=sqrt(Y1TSubVar);	
		DeltaSubSD=sqrt(DeltaSubVar);

		  
		println("  s  =  ",s);
		//println("Total observations ", iNbrTreat+iNbrCont);
		//println("Number of treated ", iNbrTreat);
		//println("Number of controls ", iNbrCont);
		//println("Y0TSubMu~Y1TSubMu~DeltaSubMu  =  ",effects[0]~effects[1]~effects[2]);
		//println("Y0TSubSE~Y1TSubSE~DeltaSubSE  =  ",Y0TSubSD~Y1TSubSD~DeltaSubSD);
	 	//println("%4.3f",effects[0]|Y0TSubSD|effects[1]|Y1TSubSD|effects[2]|DeltaSubSD);	 
	 	//exit[-1];
	
		vT[s-mins]=s;		    
		vDeltaSubMu[s-mins]=sumc(vDeltaSub)/sizer(vDeltaSub);	   //Vector of Subsampling Treatment Means
		vY0TSubSD[s-mins]=Y0TSubSD;   //Vector of Subsampling Treatment SDs
		vY1TSubSD[s-mins]=Y1TSubSD;
		vDeltaSubSD[s-mins]=DeltaSubSD;
		// Obtaining 95percent CI bounds  for multiple treatment
		vDeltaSub=sortc(vDeltaSub);
		if	(B!=300)
		{mDeltaSubCI[s-mins][]=0~0;
		}
		else
		{mDeltaSubCI[s-mins][]=(vDeltaSub[6]+vDeltaSub[7])/2 ~ (vDeltaSub[292]+vDeltaSub[293])/2;  //These CI depend upon number of subsamples
	 	}
		
	 		
	} 
	  
	print("  vT~vDelta~vDeltaSD~vDeltaSubCImin~vDeltaSubCImax  =  ",vT~vDelta~vDeltaSubSD~mDeltaSubCI);	  // Use only when estimating SD or CI from subsamples
	//print("  vT  =  ",vT);			// vector of treatment periods	
	//print("  vDelta  =  ",vDelta);		  // vector of treatment mean estimates (If subsampling was used, they are subsampling means)
	//print("  vDeltaSubSD  =  ",vDeltaSubSD);   // Use only when estimating SD or CI from subsamples
	//print("  mDeltaSubCI  =  ",mDeltaSubCI);   // Use only when estimating SD or CI from subsamples

	   	  
   return vY0T~vY0TSubSD~vY1T~vY1TSubSD~vDelta~vDeltaSubSD~mDeltaSubCI;
}

main()
{
	decl data, obs0, duur1, censor1, duur2, censor2, gender,agelayoff,agelayoffsq,agelayoffcb,agelayoff4,duurUIben,monthlayoff,yearlayoff,layoffJulAug;
	decl id2005,hourlywage,over50, month6,mDur, mX, dat00,mins,maxs,dT,d,dd,B,iSub,iMatchmeth,s,smootheffects,ismooth;

	// Upload data
	data = loadmat("jobtraining.csv");   // Load Data
	obs0=rows(data);					   // Number of Observations

	// declaring durations and indicators
	duur1 = data[][4];			 // duration until exit 	
	censor1 = data[][5];		 // indicator ==1 if exit observed
	duur2 = data[][6];			 // duration until treatment
	censor2 = data[][7];		 // indicator ==1 if treatment received
	censor2 = censor2 .* (duur2 .< duur1);
	duur2 = duur2 .* censor2 + duur1 .* (1-censor2);
	// Declaring independent variables 
	gender =data[][0];		   // gender
	agelayoff=(data[][2]-20)./40;	   //age at time of layoff
	agelayoffsq=agelayoff.^2;	   //age at time of layoff squared
	agelayoffcb=(agelayoff.^3);	   //age at time of layoff cubed
	agelayoff4=(agelayoff.^4)	;      //age at time of layoff power 4	
	id2005 = data[][1];		   // people considered low skilled in 2005
	hourlywage = data[][3];		   // dailywages in previous employment position
	over50 = data[][9]	;	   // dummy for people older than 50 at layoff
    month6 = (duur2.< 182) ;  	   //dummy for people who entered training within 6 months of falling unemployed
	duurUIben= data[][8];			// total duration UI benefits
	duurUIben= duurUIben./365;			// years UI benefits
	monthlayoff	=data[][10]	;	   // month of layoff
	yearlayoff=	data[][11];		   // year of layoff
	layoffJulAug=  (monthlayoff .== 7)	+ (monthlayoff .== 8);
		  
	mDur = duur1~censor1~duur2~censor2;
 	mX = ones(obs0,1)~gender~log(hourlywage)~duurUIben~layoffJulAug~id2005~over50~agelayoff~agelayoffsq;//~agelayoffcb;//~agelayoff4 ;




	/******* Results Output *************************************************************************/
	 


	d = 60;		// Prop. Matching subintervals
	dd= 60;		//interval for Exit probability

	iSub= 95;  // Subsample fraction of survivors
	B=300;	   //Number of subsamples  200 is fine (but 100 gives the same as well)
	ismooth=5;  // set=0 for subsampling. days over which parameter effects are smoothed  (we set ismooth=5 in paper)
	iMatchmeth=2;    // iMatchmeth=0 Propensity Matching, iMatchmeth=1 Nearest Neighbour, iMatchmeth=2 Propensity Weighting
			

	s=30;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 120;	// Evalutation length T-S

	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=30;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 270;	// Evalutation length T-S

	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=90;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 120;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=90;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 270;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=180;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 120;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	

	s=180;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 270;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	

   	
	
	println("*****************************************************************************************");
	println("/*** Regular workers ***/");
	println("*****************************************************************************************");
   
	mDur = duur1~censor1~duur2~censor2;
 	mX = ones(obs0,1)~gender~log(hourlywage)~duurUIben~layoffJulAug~over50~agelayoff~agelayoffsq;//~agelayoffcb;//~agelayoff4 ;

	mDur=selectifr(mDur,(id2005 .== 0));
	mX =selectifr(mX,(id2005 .== 0));
		

	s=30;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 120;	// Evalutation length T-S

	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=30;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 270;	// Evalutation length T-S

	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=90;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 120;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=90;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 270;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	
	
	s=180;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 120;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	

	s=180;
	mins=s-ismooth;   // Initial period for multiple treatment estimation
	maxs=s+ismooth+1;   // maxs-1 is final period for multiple treatment estimation
	dT= 270;	// Evalutation length T-S
	
	println("*****************************************************************************************");
	smootheffects=calceffect(mDur,mX,mins,maxs,dT,d,dd,B,iSub,iMatchmeth);
	println("*****************************************************************************************");
	println("S, T, Treat interval, Exit interval, Matching Method (0=Pmatch,1=NN,2=Pweight) ) ", mins~mins+dT~d~dd~iMatchmeth);
	println("Y0T~Y0TSubSD~Y1T~Y1TSubSD~Delta~DeltaSD~mDeltaSubCI ");
	println("%4.3f",sumc(smootheffects[][0])/(maxs-mins)|sumc(smootheffects[][1])/(maxs-mins)|sumc(smootheffects[][2])/(maxs-mins)|sumc(smootheffects[][3])/(maxs-mins)|sumc(smootheffects[][4])/(maxs-mins)|sumc(smootheffects[][5])/(maxs-mins)|sumc(smootheffects[][6])/(maxs-mins)|sumc(smootheffects[][7])/(maxs-mins));	


	
}