function [y,newstate]=varma_simu(constant,ar_mat,ma_mat,icovm,T,inistate);
% {y,state}=varma_simu(constant,ar_mat,ma_mat,icovm,T,inistate);
% simulates the following Varma model for T periods:
%
%  y_t = constant + ar_mat *(y'_t-1 ...y'_t-p)'+ ...
%       u_t + ma_mat * (u'_t-1 ...u_t-q')'
%
%  y_t is assumed to be stationary.
%
%  INPUT:
%           constant       K x 1
%           ar_mat         K x pK
%           ma_mat         K x qK
%           T              1 x 1
%           icovm          K x K   covariance matrix
%           inistate               state for the rndKMn procedure
% 
%  OUTPUT:
% 
%           y              K x T   series
%           newstate               state 
%
%


K=size(ar_mat,1);
p=size(ar_mat,2);
p=p/K;
q=size(ma_mat,2)/K;
maxlag=max([p;q]);


% Draw initial values from stationary distribution,
% via VAR(1) representation: YY = VAR1_const + VAR1_A YY + UU
[VAR1_A,JJ]=getAAA(ar_mat,ma_mat);     
JJ=JJ'; 

vv=1;
if (p > 1)
    vv=[vv;
        zeros(p-1,1)]; 
end;
vv=[vv;
    1];
if (q > 1)
    vv=[vv;
        zeros(q-1,1)]; 
end 

VAR1_Sigma=kron((vv*vv'),icovm); 
VAR1_const=JJ*constant;

YY_mean=inv(eye(K*(p+q))-VAR1_A)*VAR1_const; 
YY_var=inv(eye(K^2*(p+q)^2)-kron(VAR1_A,VAR1_A))*vec(VAR1_Sigma); 
YY_var=reshape(YY_VAR,K*(p+q),K*(p+q)); 

[u,s,v]=svd(YY_var); 
CC=u*sqrt(s); 

randn('state',inistate);  
vv=randn(K*(p+q),1); 
newstate=randn('state'); 
ye_ini=YY_mean+CC*vv; 

y_ini=reshape(ye_ini(1:K*p,:),K,p); 
y_ini=flipud(y_ini')';
e_ini=reshape(ye_ini(K*p+1:rows(ye_ini),:),K,q); 
e_ini=flipud(e_ini')'; 

if (maxlag-p > 0)
    y_ini=[zeros(K,maxlag-p) y_ini];
end
if (maxlag-q > 0)
    e_ini=[zeros(K,maxlag-q) e_ini]; 
end


%-------------------------------------------------------

y=[y_ini zeros(K,T)];
randn('state',newstate)
err=randn(K,T);
newstate=randn('state'); 
err=chol(icovm)'err;
err=[e_ini err]; 
 

% Simulation: -----------------------------------------
for i=(maxlag+1):(T+maxlag);
    
    yreg=flipud(y(:,(i-p):(i-1))')';
    yreg=vec(yreg);

    erreg=flipud(err(:,(i-q):(i-1))')';
    erreg=vec(erreg);
    
    y(:,i)=constant+ar_mat*yreg+err(:,i)+ma_mat*erreg;
end;

y=y(:,(maxlag+1):end);























