function [gamma_w,Sigma_w,U_w]=varma_ols(y_raw,U0_hat,p,q,R,r);
% 
% INPUT:
%      y_raw 	K x T     	K-dimensional time series
%      U0_hat	K x T  		estimated residuals from long VAR
%      p   		1 x 1      	AR - order
%      q   		1 x 1      	MA - order
%      R        	      	Restriction matrices
%      r               	
%      h_T  	1 x 1      	Order of long autoregression
%
%
% OUTPUT:
%      gamma_w         		parameter estimates
%      Sigma_w         		estimated covariance matrix
%      U_w            		estimated residuals
%


		[K,T]=size(y_raw); 
        if K>T;
            error('input data has to be K x T');        
        end;
		m=max([p q]);

		S=diag(std(y_raw').^(-1)); 
		y=S*y_raw; 

    
  
% SECOND STAGE LEAST SQUARES:
	% Setting up matrices:
		if m>0;

			XX0=[];
            for t=(m+1):T;
				if p~=0; 
					Z_t=flipud(y(:,(t-p):(t-1))');
					Z_t=vec(Z_t');
				else; 
					Z_t=[]; 
				end; 
				if q~=0; 
					U_t=flipud(U0_hat(:,(t-q):(t-1))');
					U_t=vec(U_t');
				else; 
					U_t=[]; 
				end; 
					y_tc=y(:,t)-U0_hat(:,t);
                    
					XX0=[XX0 [y_tc;Z_t;U_t]]; 
            end;
   
			z=vec(y(:,m+1:T))-kron(XX0',eye(K))*r;
    
    
							

            %if cond_numb<1000; 
			%try 
			if (rcond(R'*kron(XX0*(XX0'),eye(K))*R) > 1e-10)
                gamma_w=inv(R'*kron(XX0*(XX0'),eye(K))*R)*R'*kron(XX0,eye(K))*z;

                U_w=z-kron(XX0',eye(K))*R*gamma_w;
                U_w=reshape(U_w,K,T-m);
                Sigma_w=U_w*(U_w')/T;        


				%Check whether MA polynomial is invertible: 
				% if q >0;
					% {gamma_w,sigma_w}=checkMApoly(gamma_w,sigma_w,R,r,K,p,q);
					% U_w=z-kron(XX0',eye(K))*R*gamma_w;
					% U_w=reshape(U_w,K,T-m); 
					% sigma_w=U_w*(U_w')/T;        
				% end;
			else	
            %catch
			
                gamma_w=[];
                U_w=y;
                Sigma_w=cov(y')*1000;
				
            end 
    else; 

        gamma_w=[];
        U_w=y;
        Sigma_w=cov(y'); 

    end;


    

% Bring back to original scale: 

    if size(gamma_w,1)>0;
    
        [AA0_w,AA_w,MM_w]=getvarma_mat(gamma_w,R,r,K,p,q); 
        if p>0;
            for p_i=1:p; 
                AA_w(:,(p_i-1)*K+1:(p_i*K))=inv(S)*AA_w(:,(p_i-1)*K+1:(p_i*K))*S; 
            end; 
        end; 
        if q>0;
            for q_i=1:q; 
                MM_w(:,(q_i-1)*K+1:(q_i*K))=inv(S)*MM_w(:,(q_i-1)*K+1:(q_i*K))*S; 
            end; 
        end; 
    
    
        beta_w=vec([(eye(K)-AA0_w) AA_w MM_w]);
        gamma_w=inv(R'*R)*R'*beta_w; 

    end; 
    
    Sigma_w=inv(S)*Sigma_w*inv(S'); 
    U_w=inv(S)*U_w; 


