function irfun=varma_irfun(varma_obj,h)
% 
% usage: irfun=varma_irfun(varma_obj,h)
% 
% Compute the values of the impulse response function a VARMA model 
%  
%  A_0 y_t = mu_0 + mu_1 * t + ... + A_1 y_(t-1) + ... + A_p y_(t-p) 
%             + A_0 u_t + M_1 u_(t-1) + ... + M_q u_(t-q)
%
%   for arguments 0,1,2,...,h
%
%  INPUTS: 
%    varma_obj          VARMA model structure 
%    h (1 x 1)          max horizon of impulse responses
%
%  OUTPUTS: 
%   irfun (K^2 x (h+1)) vector of values of impulse reponse function
%
%  Depends on:
%   - 
% 

	
    mu=varma_obj.mu; 
	A_0=varma_obj.A_0;
	A=varma_obj.A;
	M=varma_obj.M; 

    K=size(A_0,1);
    D=size(mu,2);
 
    p=size(A,2)/K;
    q=size(M,2)/K;
    
    if (p > 0)
        AAr=inv(A_0)*A;
    else
        AAr=A; 
    end
     
    if (q > 0)
        MMr=inv(A_0)*M;
    else
        MMr=M; 
    end 


%------------------------
    % Get VAR(1) Representation: 
    if (q == 0) && (p == 0)
        AAA=zeros(K,K);
        J=eye(K); 
    else
        [AAA,J]=getAAA_frcstp(AAr,MMr);    
    end; 
        
    H=eye(K); 
    if p>1;
        H=[H;
            zeros((p-1)*K,K)];
    end; 
    
    if (q > 0)
        H=[H;
            eye(K)]; 
        if (q > 1) 
            H=[H;
                zeros((q-1)*K,K)]; 
        end
    end
    
    
 
    
%--------------------------
AAAj=eye(size(AAA,2));
irfun=zeros(K^2,(h+1)); 

for j=0:h;

    irfun(:,j+1)=vec(J*AAAj*H);
    AAAj=AAAj*AAA;

end


    


    

    
function [AAA,J]=getAAA_frcstp(A,M);
% {AAA,J}=getAAA(A,M);
% computes the impulse response function
% of a VARMA (p,q) model as
% y_t = AA1 y_(t-1) + ... A_0 u_t + ... + MMq u_(t-q);
%
% INPUTS:
%          A      K x KKp    AR coefficients
%                              A=[AA1: ... : AAp]
%          M      K x KKq    MA coefficients
%                              M=[MM1: ... : MMq]
%          h       1 x 1       horizon
%
%          Remark: If p or q=0 then A=[], M=[], respectively
%
% OUTPUTS:
%          irfun   K^2 x (h+1)Matrix of vectorized ir
%                              functions for j=0,...,h 
% CALLS:
%          -   
% See Luetkepohl (2005) pp. 426 for Documentation.


    K=size(A,1);

    p=size(A,2)/K;
    q=size(M,2)/K;

    % Construction of AAA:

    A11=zeros(K,K);
    A12=zeros(K,K);
    A21=zeros(K,K);
    A22=zeros(K,K);



    if p ~= 0;
        A11=A;
    end;
    if p>1;
        A11=[A11 
            [eye(K*(p-1)) zeros((p-1)*K,K)]];
    end;

    if q ~= 0;
        A12=M;
        if p>1;
            A12=[A12
                [zeros(K*(p-1),K*q)]];
        end;
    end;

    if (q ~= 0);
        A21=zeros(K*q,K);
    end;

    if (q ~= 0) & (p>0);
        A21=zeros(K*q,K*p);
    end;

    if q ~= 0;
        A22=zeros(K,K*q);
    end;

    if q>1;
        A22=[A22
            [eye(K*(q-1)) zeros(K*(q-1),K)]];
    end;

    if q==0;
        A12=[];
        A21=[];
        A22=[];
    end;


    AAA=[[A11 A12]
        [A21 A22]];


    J=eye(K);
    if p>1;
        J=[J zeros(K,K*(p-1))];
    end;

    if q>0;
        J=[J zeros(K,K)];
        if q>1;
            J=[J zeros(K,K*(q-1))];
        end;
    end;


    
    function xj=matp(x,j); 
    
        [xr,xc]=size(x); 

    if (xr~=xc); 
        error('Matrix must be square'); 
    end; 

    xj=eye(xr); 
    for i=1:j; 
        xj=x*xj; 
    end; 

    



