function [frcst_L,frcst_D,frcst_DD]=varma_frcst_wrapper(ylevel,varma_obj,dVAR,h_max); 
%
%   OUTPUT: 
%       frcstL      forecast level
%       frcstD      forecast 1st difference 
%  		frcstDD		forecast 2nd differences  
%




frcst=varma_frc(varma_obj,h_max);

T=size(ylevel,1); 


if dVAR==0;
    
    frcst_L=frcst; 
    frcst_D=frcst-[ylevel(T,:)' frcst(:,1:end-1)];
    frcst_DD=frcst_D-[(ylevel(T,:)-ylevel(T-1,:))' frcst_D(:,1:end-1)]; 
    
   
else;
    
    for k=1:K;
        
        if dVAR(k)==0;
    
            frcst_L(k,:)=frcst(k,:); 
            frcst_D(k,:)=frcst(k,:)-[ylevel(T,k) frcst(k,1:end-1)];
            frcst_DD(k,:)=frcst_D(k,:)-[(ylevel(T,k)-ylevel(T-1,k))' frcst_D(k,1:end-1)]; 
    
            
        elseif dVAR(k)==1;
            
			frcst_D(k,:)=frcst(k,:);
            frcst_DD(k,:)=frcst_D(k,:)-[(ylevel(T,k)-ylevel(T-1,k))' frcst_D(k,1:end-1)]; 
            
            frcst_L(k,:)=nan(1,h_max); 
            frcst_L(k,1)=ylevel(T,k)'+frcst(k,1);
    
            for h=2:h_max; 
                frcst_L(k,h)=frcst_L(k,h-1)+frcst(k,h); 
            end; 

			elseif dVAR(k)==2; 
            
            frcst_DD(k,:)=frcst(k,:);
            
            frcst_L(k,:)=nan(1,h_max);
            frcst_D(k,:)=nan(1,h_max); 
            
            frcst_D(k,1)=(ylevel(T,k)-ylevel(T-1,k))+frcst_DD(k,1); 
            for h=2:h_max; 
                frcst_D(k,h)=frcst_D(k,h-1)+frcst_DD(k,h); 
            end;

            frcst_L(k,1)=ylevel(T,k)+frcst_D(k,1); 
            for h=2:h_max; 
                frcst_L(k,h)=frcst_L(k,h-1)+frcst_D(k,h); 
            end;
        end; 
    end;
end; 




