function yfcmat=varma_frc(varma_obj,fc_h);
% Computes h-step ahead point forecasts from a VARMA model 
%  
%  A_0 y_t = mu_0 + mu_1 * t + ... + A_1 y_(t-1) + ... + A_p y_(t-p) 
%             + A_0 u_t + M_1 u_(t-1) + ... + M_q u_(t-q)
%
%
%  INPUTS: 
%
%
%  OUTPUTS: 
%

	y=(varma_obj.data)'; 
    res=varma_obj.res;
	
    
    mu=varma_obj.mu; 
	A_0=varma_obj.A_0;
	A=varma_obj.A;
	M=varma_obj.M; 

    K=size(A_0,1);
    
    T=size(y,2);
	D=size(mu,2);
 
    if size(res,2)~=T; 
        error('cols of observations and residuals must be identical'); 
    end; 

    p=size(A,2)/K;
    q=size(M,2)/K;

    if p>0;
        AAr=inv(A_0)*A;
    else; 
        AAr=A; 
    end;
 
    if q>0;
        MMr=inv(A_0)*M;
    else; 
        MMr=M; 
    end; 


    %------------------------
    % Get VAR(1) Representation: 

    [AAA,J]=getAAA_frcstp(AAr,MMr);    

    H=eye(K); 
    
    if p>1;
        H=[H;
            zeros((p-1)*K,K)];
    end; 
    
    if q>0;
        H=[H;
            eye(K)]; 
    end; 
    
    if q>1; 
        H=[H;
            zeros((q-1)*K,K)]; 
    end; 
    
    %--------------------------
    % Get last vector of observations 
    % in VAR(1) represeentation: 

    if p>0;
        Y_T=y(:,(T-p+1):T);
        Y_T=vec(flipud(Y_T')');
    else; 
        Y_T=[]; 
    end; 
    if q>0;
        U_T=res(:,(T-q+1):T);
        U_T=vec(flipud(U_T')');
    else; 
        U_T=[]; 
    end; 

    YY_T=[Y_T
        U_T];
    %---------------------------
    

       
    v=zeros(size(YY_T,1),1); 
    if D>0;
		v(1:K,:)=mu*(exp( (0:(D-1))*log(T+1) ) )';
		%mu_0+mu_1*(T+1);
	end;

    cov_res=nancov(res'); 
    sigma_h=zeros(K,K); 


    yfcmat=[];
    

    if ((p > 0)||(q > 0))

        for h=1:fc_h;

            % Point forecasts:        
            yfc=J*(v+matp(AAA,h)*YY_T);
            yfcmat=[yfcmat yfc];

            if h ~= fc_h;
                v_n=zeros(size(YY_T,1),1); 
                if D>0;
                    v_n(1:K,:)=mu*(exp( (0:(D-1))*log(T+h+1) ) )';
                    %mu_0+mu_1*(T+h+1); 
                end;
                v=v_n+AAA*v; 
            end;   
        end;

    else
        for h=1:fc_h;

            % Point forecasts:        
            yfc=v;
            yfcmat=[yfcmat yfc];

            if h ~= fc_h;
                v_n=zeros(size(YY_T,1),1); 
                if D>0;
                    v_n(1:K,:)=mu*(exp( (0:(D-1))*log(T+h+1) ) )';
                    %mu_0+mu_1*(T+h+1); 
                end;
                v=v_n; 
            end;   
        end;
        
    end
        


    
function [AAA,J]=getAAA_frcstp(A,M);
% {AAA,J}=getAAA(A,M);
% computes the impulse response function
% of a VARMA (p,q) model as
% y_t = A_1 y_(t-1) + ... + u_t + M_1 u_(t-1)+... + M_q u_(t-q);
%
% INPUTS:
%          A      K x KKp    AR coefficients
%                              A=[A_1: ... : A_p]
%          M      K x KKq    MA coefficients
%                              M=[MM1: ... : MMq]
%          h       1 x 1       horizon
%
%          Remark: If p or q=0 then A=[], M=[], respectively
%
% OUTPUTS:
%          irfun   K^2 x (h+1)Matrix of vectorized ir
%                              functions for j=0,...,h 
% CALLS:
%          -   
% See Luetkepohl (2005) pp. 426 for Documentation.


    K=max([size(A,1);size(M,1)]); 

    p=0;q=0;
    if (K ~= 0)
        p=size(A,2)/K;
        q=size(M,2)/K;
    end
    
        
    
    % Construction of AAA:

    A11=zeros(K,K);
    A12=zeros(K,K);
    A21=zeros(K,K);
    A22=zeros(K,K);



    if p ~= 0;
        A11=A;
    end;
    if p>1;
        A11=[A11 
            [eye(K*(p-1)) zeros((p-1)*K,K)]];
    end;

    if q ~= 0;
        A12=M;
        if p>1;
            A12=[A12
                [zeros(K*(p-1),K*q)]];
        end;
    end;

    if (q ~= 0);
        A21=zeros(K*q,K);
    end;

    if (q ~= 0) & (p>0);
        A21=zeros(K*q,K*p);
    end;

    if q ~= 0;
        A22=zeros(K,K*q);
    end;

    if q>1;
        A22=[A22
            [eye(K*(q-1)) zeros(K*(q-1),K)]];
    end;

    if q==0;
        A12=[];
        A21=[];
        A22=[];
    end;


    AAA=[[A11 A12]
        [A21 A22]];


    J=eye(K);
    if p>1;
        J=[J zeros(K,K*(p-1))];
    end;

    if q>0;
        J=[J zeros(K,K)];
        if q>1;
            J=[J zeros(K,K*(q-1))];
        end;
    end;


        
function xj=matp(x,j); 
    
        [xr,xc]=size(x); 

    if (xr~=xc); 
        error('Matrix must be square'); 
    end; 

    xj=eye(xr); 
    for i=1:j; 
        xj=x*xj; 
    end; 

    



