function varma_obj=var_ols(y,D,p);
% [A_hat,CovM_hat,U_hat]=var_ols(y,D,p);
%
% estimates a VAR(p) by OLS. 
%
% INPUTS
% y       				K x T   	series
% p       				1 x 1   	lag order
% D     				1 x 1   	dummy: 1 -> constant, 0 -> no constant
%
% outputs:
%	varma_obj			varma object 
	



[K,T]=size(y);
 
if K>T;
	error('var_ols: input data has to be K x T');        
end;
    
ys=y(:,p+1:end);
Te=T-p; 
	
if (p ~= 0) 
	Y=flipud(y(:,1:(1+p-1))');
	Y=vec(Y');
		
	for i=2:(T-p);
		xx=flipud(y(:,i:(i+p-1))')';
		xx=vec(xx);
        Y=[Y xx];
	end;

	if D==1;
		Y=[ones(1,(T-p));Y];
	else;
		Y=Y;
	end;
	
	
	
	A_hat=(Y*(Y'))\((ys*(Y'))');
	A_hat=A_hat';
	U_hat=(ys-A_hat*Y);
	
else 
	if D==1;
		Y=ones(1,size(ys,2));     
		A_hat=mean(ys')';
		U_hat=(ys-A_hat*Y);
	else; 
		A_hat=[];
		U_hat=ys;
	end; 
end; 

CovM_hat=U_hat*(U_hat')/(Te-K*p-D);

% Package
if D==0;
	mu_hat=[];
elseif D==1;
	mu_hat=A_hat(:,1);
	A_hat=A_hat(:,2:end);
end; 

U_hat=[nan(K,p) U_hat];
	
varma_obj.data=y; 
varma_obj.res=U_hat;
varma_obj.CovM=CovM_hat; 
varma_obj.mu=mu_hat; 
varma_obj.A_0=eye(K); 
varma_obj.A=A_hat; 
varma_obj.M=[]; 	
	