% tests_yr.m - Test-Programm fr das Schtzverfahren
% von 
% Ltkepohl and Poskitt, Poskitt and 
% Yap & Reinsel:

clear; 

addpath('KronIdx');

dbstop if error
randn('state',0); 



% DGP 1 ------------------------------------------------------------- 

data=randn(100,2); 
    
    foptions.CointOrder=size(data,2)-1;
    foptions.Identification='rec'; 

    foptions.LagOrder=[1;2]; 

    varma_obj=estimate_civarma_poskitt(data,foptions);
    varma_obj=estimate_civarma_yapreinsel(data,foptions);
    

    foptions.LagOrder=[2;1]; 

    varma_obj=estimate_civarma_poskitt(data,foptions);
    varma_obj=estimate_civarma_yapreinsel(data,foptions);

    foptions.LagOrder=[0;1]; 

    varma_obj=estimate_civarma_poskitt(data,foptions);
    varma_obj=estimate_civarma_yapreinsel(data,foptions);

    foptions.LagOrder=[1;0]; 

    varma_obj=estimate_civarma_poskitt(data,foptions);
    varma_obj=estimate_civarma_yapreinsel(data,foptions);

      
    foptions.LagOrder=[1;1]; 

    varma_obj=estimate_civarma_poskitt(data,foptions);
    varma_obj=estimate_civarma_yapreinsel(data,foptions);


    foptions.Identification='fma';
    foptions.LagOrder=[1;0]; 
    
    varma_obj=estimate_civarma_poskitt(data,foptions);
    varma_obj=estimate_civarma_yapreinsel(data,foptions);
        
    
    

    
    

% DGP 2 ------------------------------------------------------------- 

mu_0=0;
mu_1=0;
A0=eye(2);
A=[1 0;
    .2 0.3]; 
M=[0.2 0
    0 0.2]; 

cov_mat=eye(2);
T=1000; 
    
foptions.LagOrder=[1;1]; 
foptions.CointOrder=1;
foptions.Identification='rec'; 
          
[y,u]=simulate_varma(mu_0,mu_1,A0,A,M,cov_mat,T);
data=y'; 
    
varma_obj=estimate_civarma_poskitt(data,foptions);

disp('************************************');
disp('************************************');
disp('DGP 2');
disp('');
disp('A_0: ');
eye(2)
disp('A: ');
A

disp('M: ');
M
disp('************************************');

disp('DGP 2 - Poskitt'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M
    
    
varma_obj=estimate_civarma_yapreinsel(data,foptions);

disp('DGP 2 - Yap and Reinsel'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M
    
    
% DGP 3 ------------------------------------------------------------- 
% Ltkepohl & Claessen: 
T=1000;
VARMAmodel_true=setVARMAparameters(2); 
disp('************************************');
disp('************************************');

disp('DGP 3');
disp('');
disp('A_0: ');
VARMAmodel_true.A_0
disp('A: ');
VARMAmodel_true.A

disp('M: ');
VARMAmodel_true.M
disp('************************************');


[ts_data,ts_errors]=simulateVARMAmodel(VARMAmodel_true,T); 

data=ts_data; 

foptions.LagOrder=[2;1;1;1]; 
foptions.CointOrder=1;
foptions.Identification='rec'; 

% dbstop in estimate_civarma_poskitt at 55

varma_obj=estimate_civarma_poskitt(data,foptions);

disp('DGP 3 - Poskitt'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M
    
    
varma_obj=estimate_civarma_yapreinsel(data,foptions);

disp('DGP 3 - Yap and Reinsel'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M

    
% DGP 4 ------------------------------------------------------------- 

% Own example of FMA form
VARMAmodel_true=setVARMAparameters(3); 
T=2000;
disp('************************************');
disp('************************************');
disp('DGP 4');
disp('');
disp('A_0: ');
VARMAmodel_true.A_0
disp('A: ');
VARMAmodel_true.A

disp('M: ');
VARMAmodel_true.M
disp('************************************');

initial_values=[1000;1001;1000];
[ts_data,ts_errors]=simulateVARMAmodel(VARMAmodel_true,T,initial_values); 

data=ts_data; 

foptions.LagOrder=[1;1]; 
foptions.CointOrder=1;
foptions.Identification='fma'; 

varma_obj=estimate_civarma_poskitt(data,foptions);



disp('DGP 4 - Poskitt'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M
    
    
varma_obj=estimate_civarma_yapreinsel(data,foptions);

disp('DGP 4 - Yap and Reinsel'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M

   
    
% DGP 5 ------------------------------------------------------------- 

% Own example of FMA form
VARMAmodel_true=setVARMAparameters(5); 
T=1000;
disp('************************************');
disp('************************************');
disp('DGP 5');
disp('');
disp('A_0: ');
VARMAmodel_true.A_0
disp('A: ');
VARMAmodel_true.A

disp('M: ');
VARMAmodel_true.M
disp('************************************');


[ts_data,ts_errors]=simulateVARMAmodel(VARMAmodel_true,T); 

data=ts_data; 


foptions.LagOrder=[2;1;1]; 
foptions.CointOrder=1;
foptions.Identification='rec'; 

varma_obj=estimate_civarma_poskitt(data,foptions);

disp('DGP 5 - Poskitt'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M
    
    
varma_obj=estimate_civarma_yapreinsel(data,foptions);

disp('DGP 5- Yap and Reinsel'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M

% DGP 6 ------------------------------------------------------------- 

mu_0=0;
mu_1=0;
A0=eye(3);
A=[1 0 0;
    .2 0.3 0;
    0 0 1];

M=zeros(3,3); 

cov_mat=eye(3);
T=1000; 

         
[y,u]=simulate_varma(mu_0,mu_1,A0,A,M,cov_mat,T);
data=y'; 

foptions.Identification='fma';
foptions.LagOrder=[1;0]; 
foptions.CointOrder=1;


varma_obj=estimate_civarma_poskitt(data,foptions);

disp('DGP 6 - Poskitt'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M
    
    
varma_obj=estimate_civarma_yapreinsel(data,foptions);

disp('DGP 6 - Yap and Reinsel'); 
    varma_obj.A_0
    varma_obj.A
    varma_obj.M


















