% test_fmaspc_maxpt.m
% Program to test VARMA FMA specification and maximal allowable orders. 

clear; 
dbstop if error

% ---------------------------------------------------------------------
% MC parameters

T=150; 
N=200; 
int_dgp=10;

% ---------------------------------------------------------------------
% MC replications 

VARMAmodel=setVARMAparameters(int_dgp);
K=size(VARMAmodel.A_0,1); 



minp=0; 
minq=0;

h_T=round(log(T));
nu=0.5; 
maxp=h_T-2;
maxq=h_T+4; 



for n=1:N;

	[ts_data,ts_errors]=simulateVARMAmodel(VARMAmodel,T); 

    y=ts_data';   
    mean_y=mean(y')';
    yma=y-kron(ones(1,T),mean_y);
    
    
    [crit_mat,crit_p,crit_q]=ord_varma_fma(yma,minp,maxp,minq,maxq,h_T,nu);

    crit_mat
    

end;




 







