function [y,u]=simulate_varma(mu_0,mu_1,A0,A,M,cov_mat,T)

[K,Kp]=size(A); 
p=Kp/K; 
[K2,Kq]=size(M); 
q=Kq/K; 

m=max([p;q]);

y_initial=zeros(K,m); 

P=chol(cov_mat)'; 
u=P*randn(K,m+T); 


y=nan(K,T); 
y=[y_initial y]; 

for t=m+1:(T+m); 
    Z_t=vec(flipud(y(:,t-p:t-1)')');
    U_t=vec(flipud(u(:,t-q:t-1)')'); 
    y(:,t)=inv(A0)*(mu_0+mu_1*t+A*Z_t+M*U_t)+u(:,t);
end; 


y=y(:,(m+1):(T+m)); 











