function [y,u]=simulateVARMAmodel(varma_obj,T,initial_values)
% description ... 

%-------------------------------------------------------
% check inputs 
if (nargin < 2) 
	error('too few arguments'); 
end

if (nargin >3) 
    error('too many arguments');
end

%-------------------------------------------------------
% extract coefficients

A_0=varma_obj.A_0;
A=varma_obj.A;
M=varma_obj.M;

[K,Kp]=size(A); 
p=Kp/K; 
[K2,Kq]=size(M); 
q=Kq/K; 
m=max([p;q]);

mu_mat=varma_obj.mu;
d=size(mu_mat,2);
if (d > 0)
    mu_0=mu_mat(:,1);
    if (d > 1)
        mu_1=mu_mat(:,2);
    else 
        mu_1=zeros(K,1); 
    end
end

CovM=varma_obj.CovM; 

%-------------------------------------------------------
% simulation

if(nargin < 3) 
    y_initial=zeros(K,m); 
else
   y_initial=initial_values; 
end


y=[y_initial nan(K,T)]; 

P=chol(CovM)'; 
u=P*randn(K,m+T); 

for t=m+1:(T+m); 
    Y_t=vec(flipud( y(:,(t-p):(t-1))' )');
    U_t=vec(flipud( u(:,(t-q):(t-1))' )'); 
    
	y(:,t)=inv(A_0)*(mu_0+mu_1*t+A*Y_t+M*U_t)+u(:,t);
end; 

y=y(:,(m+1):(m+T))'; 
u=u(:,(m+1):(m+T))';















