function varma_obj=setVARMAparameters(int_dgp)
%  usage: varma_obj=setVARMAparameters(int_dgp);
%
%  Set parameters for MC study on FMA and reverse
%  Echelon form.
%
% Inputs:
%   int_dgp                    number of dgp 
%
% Outputs: 
%   varma_obj
% 
% Calls: 
%   -
%

% Load data set specifics & data set
switch int_dgp
    case{1}
	
        alfa=[ -.398   .433;
                .121  -.340 ;
                .103  .166];
				
        beta=[1 0; 
              0 1;
              -.8 -.48]; 
                       
                
        M_1=(-1)*[ -0.7  .0  .0;
                .3  -0.5  .0; 
                -.2  .1  .1];
        
            
        CovM=[  1.0  .5  .4;
            .5  1.0  .7;
            .4  .7  1.0];
        
        Pi=alfa*(beta'); 
        
        A_0=eye(3); 
        
        A=Pi+A_0;
        M=M_1; 
        
        mu=zeros(3,1); 
    
    case{2} 
        % Ltkepohl & Claessen (1997) 
        
        A_0 =[  1  0  0  0 ;
                -0.173  1  0  0; 
                -0.350  0  1  0 ;
                0.205 0  0  1 ];
        

        Gamma_1=[0.497  0.123  -0.548  -0.679;
                0  0  0  0 ;
                0  0  0  0 ;
                0  0  0  0 ]; 


        M_1=[   -0.268  0  0  0 ;
                0.143  0.035  0.490  -0.373 ;
                0.115  0.164  0.550  -0.442 ;
                0.168  0.094  0.208  -0.810 ];

        M_2=[   0.151  0.112  0.104  0.464;
                0  0  0  0;
                0  0  0  0;
                0  0  0  0];


        alfa=[  0.013 ;
                0.028 ;
                0.00009 ;
                0.0046];

        beta=[  1 ;
                -0.343 ;
                -16.72 ;
                19.35 ];

        PiMat = alfa*(beta'); 
        
        A_2   = -Gamma_1; 
        A_1   = PiMat-A_2+A_0;  
        % PiMat=A_1 + A_2 - A_0 = > A_1 = PiMat - A_2 + A_0 

        A=[A_1 A_2]; 
        M=[M_1 M_2]; 
        
        CovM=[ 0.6989    0.0749   -0.1004   -0.4007;
                0.0749    0.8723    0.2579    0.2148;
                -0.1004    0.2579    0.7214    0.3328;
                -0.4007    0.2148    0.3328    0.7897];
        
        CovM=CovM*(1e-004); 
        
        mu=zeros(4,1); 
        
                
        
    case{3}
       
        A_0=eye(3); % what is mu here? 
       
        M= [0.35         0         0;
             0    0.35         0;
             0         0    0.35 ];       

        beta= [ 1   0;
             0    1;
       -1.04   -1.14];

        alfa=[-0.30  0.31;
        0.00   -0.02;
        0.14   -0.13];

        A=alfa*(beta')+eye(3); 

        CovM=[0.16    0.14    0.06;
              0.14    0.16    0.08;
              0.06    0.08    0.07]; 

        mu=zeros(3,1); 

    case{4}
        
        CovM=eye(2); 
        
        mu=zeros(2,1); 
        
        A_0=eye(2); 
  
        beta=[1;
            -1]; 
        
        alfa=[0.1;
            0.5]; 
        
        A=alfa*(beta')+eye(2); 
        
        M=[-0.25 0;
            0 -0.25]; 
        

	
	
	case{5}
	
		% DGP3: 
		lambda.ar_1 = 0.7;
		lambda.ar_2 = 0.4;
		lambda.ma_1 = 0.6;
		lambda.ma_2 = -0.5; 
	
		[mu,A_0,A,M,CovM,alfa,beta]=getBartelLuetkepohlDGP(lambda); 

	
    
    case{6}
       
        A_0=eye(3); % what is mu here? 
       
        Gamma_1= [0.35         0         0;
             0    0.35         0;
             0         0    0.35 ];       
       
                
        M_1= [0.35         0         0;
             0    0.35         0;
             0         0    0.35 ];       
         
        M_2= [0.1         0         0;
             0    0.1         0;
             0         0    0.1];       
         
         

        beta= [ 1   0;
             0    1;
       -1.04   -1.14];

        alfa=[-0.30  0.31;
        0.00   -0.02;
        0.14   -0.13];

        CovM=[0.16    0.14    0.06;
              0.14    0.16    0.08;
              0.06    0.08    0.07]; 

        mu=zeros(3,1); 
        
        PiMat = alfa*(beta'); 
        
        A_2   = -Gamma_1; 
        A_1   = PiMat-A_2+A_0;  
        % PiMat=A_1 + A_2 - A_0 = > A_1 = PiMat - A_2 + A_0 

        A=[A_1 A_2]; 
        M=[M_1 M_2];
 
        
       	
	case{7}
	
		% DGP4: 
		lambda.ar_1 = 0.7;
		lambda.ar_2 = 0.4;
		lambda.ma_1 = -0.95;
		lambda.ma_2 = -0.7; 
	
		[mu,A_0,A,M,CovM,alfa,beta]=getBartelLuetkepohlDGP(lambda); 
        
       	
	case{8}
	
		% DGP5: medium AR and large positive MA eigenvalues
        
		lambda.ar_1 = 0.7;
		lambda.ar_2 = 0.4;
		lambda.ma_1 = 0.95;
		lambda.ma_2 = 0.7; 
	
		[mu,A_0,A,M,CovM,alfa,beta]=getBartelLuetkepohlDGP(lambda); 
    
	case{9}
	
		% DGP6: large negative AR and medium MA eigenvalues
        
		lambda.ar_1 = -0.95;
		lambda.ar_2 = -0.7;
		lambda.ma_1 = 0.6;
		lambda.ma_2 = -0.5; 
	
		[mu,A_0,A,M,CovM,alfa,beta]=getBartelLuetkepohlDGP(lambda); 
        
	case{10}
	
		% DGP7: large positive AR and medium MA eigenvalues
        
		lambda.ar_1 = 0.95;
		lambda.ar_2 = 0.7;
		lambda.ma_1 = 0.6;
		lambda.ma_2 = -0.5; 
	
		[mu,A_0,A,M,CovM,alfa,beta]=getBartelLuetkepohlDGP(lambda); 
        
        
    
    otherwise
        error('invalid dgp number');
        
end



varma_obj.beta=beta;
varma_obj.alfa=alfa; 
varma_obj.CovM=CovM; 
varma_obj.mu=mu; 
varma_obj.A_0=A_0; 
varma_obj.A=A; 
varma_obj.M=M; 



function [mu,A_0,A,M,CovM,alfa,beta]=getBartelLuetkepohlDGP(lambda); 


CovM=eye(3); 


b_1=(15/7) + (10/7)*(-lambda.ar_1-lambda.ar_2+(3/8)*lambda.ar_1*lambda.ar_2);

b_2=(-1)+(5/4)*lambda.ar_1*lambda.ar_2; 

m_1=(3/5)-lambda.ma_1-lambda.ma_2;

m_2=(3/5)*m_1+lambda.ma_1*lambda.ma_2;

mu=zeros(3,1);
A_0=[1 0 0;
	-0.5 1 0;
	 0 0 1]; 

A_2=[0.8 0 0.8;
	0 0 0;
	0 0 0]; 
	
beta=[1 -0.6 0.3]'; 

alfa=zeros(3,1);
alfa(1)=b_1;
alfa(2)=b_2;
alfa(3)=b_2;

A_1=alfa*(beta')-A_2-A_0;

A=[-A_1 -A_2];

M=[-0.6 0 0 0 0 0;
	0 0 0 0 0 0;
	0 0 0 0 0 0];

M(1,4)=m_2;
M(1,6)=m_2;
M(3,1)=m_1;
M(3,3)=m_1;








	
	
	










	
	
	
	
	
	
	




























