function varma_obj=rwmodel(data,addInputs); 
% varma_obj=rwmodel(data)
% creates a special varma object, the random walk model.
% 
% inputs: 	
%	data				numeric, data vector (T x K) 
% outputs: 
%	varma_obj			varma object 


if isa(data,'double')==0; 
	error('rwmodel: input must be double');
end; 

[T,K]=size(data); 

U_hat=diff(data)';
CovM_hat=U_hat*(U_hat')/size(U_hat,2);
U_hat=[nan(K,1) U_hat];


varma_obj.data=data; varma_obj.res=U_hat;
varma_obj.CovM=CovM_hat; 
varma_obj.mu=[]; 
varma_obj.A_0=eye(K); 
varma_obj.A=eye(K); 
varma_obj.M=[]; 







 