% usage: [h]=plot_cumse(results1, results2, h)
% 
% Plot cumulative sum of differences of squared errors of two 
% result sets. 
%
function [h]=plot_cumse(results1, results2, h)


    e1=results1.ferrors(:,:,h);    % frcst errors (T x K) 
    e2=results2.ferrors(:,:,h); 
    
    se_diff=e1.^2-e2.^2; 
    
    se_diff(isnan(se_diff))=0;      % replace NaNs with zeros 
    
    cum_sse=cumsum(se_diff);
    
    start_idx = max(find(isnan(results1.ferrors(:,1,h)))); 
    
    h=plot(results1.dates(start_idx:end,:), cum_sse(start_idx:end,1),'k-');
    hold on
    plot(results2.dates(start_idx:end,:), cum_sse(start_idx:end,2),'k--');
    hold off
    
    
    
    
    
    















