function [aic,aic_p,hq,hq_p,sc,sc_p]=order_var(y,mud,minp,maxp);
%     Lag selection in a VAR with/without intercept.
%     Function computes the AIC,HQ and BIC criterion. 
% 
%     USAGE:
%     [aic,aic_p,hq,hq_p,sc,sc_p]=ord_VAR(y,mud,maxp,method);
%     
%     INPUTS
%     y           K x T       series
%     mud         1 x 1       dummy: 0 - no intercept, 1 - intercept
%     minp        1 x 1       minimal lag order
%     maxp        1 x 1       maximal lag order
%    
%     OUTPUT
%     aic         maxp+1 x 2  aic for lags 0 - maxp
%     aic_p       1 x 1       optimal lag length acc. to aic      
%     hq          maxp+1 x 2  hq for lags 0 - maxp          
%     hq_p        1 x 1       optimal lag length acc. to hq
%     sc          maxp+1 x 2  sc for lags 0 - maxp
%     sc_p        1 x 1       optimal lag length acc. to sc



[K,T]=size(y);

if (K>T)
	error('order_var: data has to have dimensions K x T');
end

if (mud ~= 0)&&(mud ~=1)
	error('order_var: order of deterministic polynomial has to be 0 or 1');
end



aic=zeros(maxp+1,1);
hq=zeros(maxp+1,1);
sc=zeros(maxp+1,1);



for p=0:1:maxp;
    
    
    var_p=var_ols(y(:,(maxp+1-p):end),mud,p);
    
   
	u=var_p.res(:,(p+1):end); 
	
    detCovM=det((u*u')/(T-maxp));
    
	
    aic(p+1)=log(detCovM)+2*(p*(K^2))/(T-maxp);
    hq(p+1)=log(detCovM)+2*log(log(T-maxp))*(p*(K^2))/(T-maxp);
    sc(p+1)=log(detCovM)+log(T-maxp)*(p*(K^2))/(T-maxp);

end;

orders_v=(0:1:(maxp))';

aic=[orders_v aic];
hq=[orders_v hq];
sc=[orders_v sc];

aic=aic(minp+1:end,:); 
hq=hq(minp+1:end,:); 
sc=sc(minp+1:end,:); 

[min_aic,mini_aic]=min(aic(:,2)); 
[min_hq,mini_hq]=min(hq(:,2)); 
[min_sc,mini_sc]=min(sc(:,2)); 


aic_p=aic(mini_aic,1);
hq_p=hq(mini_hq,1);
sc_p=sc(mini_sc,1);





