function [crit_mat,crit_p,crit_q]=ord_varma_fma_trdp(data,minp,maxp,minq,maxq,h_T);
    % Lag selection in a VARMA in FMA form. 
	%
    % INPUTS
    % data        K x T           time series
    % minp        1 x 1           minimal AR lag order
    % maxp        1 x 1           maximal AR lag order
    % minq        1 x 1           minimal MA lag order
    % maxq        1 x 1           maximal MA lag order
	%
    % OUTPUTS
    % crit_mat    maxp+1 x maxq+1 crit_mat for lags 0 - maxp, 0 - maxq
    % crit_p      1 x 1           optimal AR lag length       
    % crit_q      1 x 1           optimal MA lag length 
	
    % PENALTY TERM: 
    nu=0.2; 
	
	[K,T]=size(data);
    if K>T;
        error('input data has to be K x T');        
    end;

%     mean_data=mean(data')'; 
%     y=data-kron(ones(1,T),mean_data); 
     
    y=data; 
   
    
	maxmaxpq=max([maxp;maxq]);
	s_T=h_T+maxmaxpq;
	N=T-s_T;

	[Pi_hT,sigma_hT,U_hT]=var_ols(y,0,h_T);
	U_hT=[zeros(K,h_T) U_hT];
	
	for p=0:1:maxp;
        
		for q=0:1:maxq;
            
			m=max([p;q]);
            
			if m>0;
                
				[R,r]=fma_restrictions(K,p,q);
				numbP=size(R,2);
                
				[gamma_w,sigma_w,U_w]=varma_ols(y(:,(s_T+1-m):T),U_hT(:,(s_T+1-m):T),p,q,R,r);
                sigma_w=(U_w*(U_w'))/N;
                
			else;
                
				numbP=0;
				sigma_w=y(:,(s_T+1-m):T)*(y(:,(s_T+1-m):T)')/N;
                
			end;
        
            traceCovM=trace(sigma_w);
            
            crit_mat(p+1,q+1)=traceCovM+numbP*(log(N)^(1+nu))/N;

            
		end;
        
	end;

	crit_mat2=crit_mat(minp+1:maxp+1,:);     
    crit_mat2=crit_mat2(:,minq+1:maxq+1);     
    
    [crit_p,crit_q]=maxindmat(-crit_mat2);
    crit_p=crit_p+minp-1;
    crit_q=crit_q+minq-1; 

	
    crit_mat=[(0:maxp)' crit_mat];
    crit_mat=[(-1:maxq);crit_mat]; 
			
			 