function mse_frcst = mse_forecast(dl_frcst,h_set,m_set,T_s,actuals)

% mse_frcst = mse_forecast(beta,h_max)
% Computes forecasts of y_t for forecast horizons and maturities of 
% interst for Diebold-Li model.
% 
% inputs: 	
%	dl_frcst		forecasted values, array (T x h_max x maturities)
%   h_set           set of forecast horizons of interest, vector
%   m_set           set of maturities of interest, vector
%   actuals         yield data
%     
% outputs: 
%	mse_frcst		MSE of forecasts values, array (T x h_max x maturities)

% Generation of relevant objects
[T,~,~] = size(dl_frcst);
[h,~]=size(h_set);
[m,~]=size(m_set);
extract_frcst=nan(T-T_s,h,m);%-0
mean_frcst = nan(m,h);
std_frcst = nan(m,h);
mse_frcst = nan(m,h);



% -------------------------------------------------------------------------
% Computation of MSE's

% Extraction of relevant data
actuals =  actuals(T_s+1:end,m_set); %+1


for i=1:h;  
    ii=h_set(i);
    
    % Extraction of relevant forecasts
    extract_frcst(:,i,:) = dl_frcst(T_s-ii+1:end-ii,ii,m_set); %+1
    
    % Computation of forecast errors
    frcst_error=actuals-squeeze(extract_frcst(:,i,:));
    
    % Computation of mean of forecast errors
    mean_frcst(:,i) = nanmean(frcst_error);
    
    % Computation of std. of forecast errors
    std_frcst(:,i) = nanstd(frcst_error);
    
    % Computation of MSE
    mse_frcst(:,i)= diag(frcst_error'*frcst_error)/(T-T_s-1);%-1
    
end;

mean_frcst
std_frcst
sqrt(mse_frcst)








