function mse_frcst = mse_forecast(dl_frcst,h_set,m_set,T_s,actuals)

% mse_frcst = mse_forecast(beta,h_max)
% Computes forecasts of y_t for forecast horizons and maturities of 
% interst for Diebold-Li model according to our design. Forecast will
% be made from T_s onwards, i.e. the first forecast for horizons h is
% made at T_s + h! Hence, we have T-T_s-h forecast errors.
% 
% inputs: 	
%	dl_frcst		forecasted values, array (T x h_max x maturities)
%   h_set           set of forecast horizons of interest, vector
%   m_set           set of maturities of interest, vector
%   actuals         yield data
%     
% outputs: 
%	mse_frcst		MSE of forecasts values, array (T x h_max x maturities)

% Generation of relevant objects
[T,~,~] = size(dl_frcst);
[h,~]=size(h_set);
[m,~]=size(m_set);
mean_frcst = nan(m,h);
std_frcst = nan(m,h);
mse_frcst = nan(m,h);



% -------------------------------------------------------------------------
% Computation of MSE's

for i=1:h;  
    ii=h_set(i);
     
    % Extraction of relevant data
    actuals_f =  actuals(T_s+ii:end,m_set); 
    
    % Extraction of relevant forecasts
    extract_frcst = squeeze(dl_frcst(T_s:end-ii,ii,m_set)); 
    
    % Computation of forecast errors
    frcst_error=actuals_f- extract_frcst;
    
    % Computation of mean of forecast errors
    mean_frcst(:,i) = nanmean(frcst_error);
    
    % Computation of std. of forecast errors
    std_frcst(:,i) = nanstd(frcst_error);
    
    % Computation of MSE
    mse_frcst(:,i)= diag(frcst_error'*frcst_error)/(T-T_s-ii+1);
    
end;

%mean_frcst
%std_frcst
%mse_frcst








