function table=mat2table(mat,cellstr_column_names,str_tablenote,str_filename,str_caption,str_label,str_tablehead,Idx_bold,int_hlines,int_vspaces,sideways)




[n_rows,n_cols]=size(mat);

cellstr_column_names2=cellstr_column_names;

idx=1;
idx2=1; 
while (size(cellstr_column_names2,1)<n_rows)

	str=[cellstr_column_names{idx} num2str(idx2)];
	cellstr_column_names2=[cellstr_column_names2;str]; 

	if (idx==size(cellstr_column_names,1))
		idx=1; 
	else
		idx=idx+1;
	end
	
	idx2=idx2+1; 	
	
end

if (sideways == 1)
    table='\begin{sidewaystable} \centering';
else
    table='\begin{table}[h] \centering'; 
end 

    
table=char(table,[ '\caption{' str_caption  '}' ' \label{tab:' str_label    '}']);

table_cols=n_cols+numel(int_vspaces); 
tmp_str='l'; 
for col_idx=1:table_cols; 
	tmp_str=[tmp_str 'c'];
end; 


t_r=['\begin{tabular}{' tmp_str '} \hline \hline  ']; 
table=char(table,t_r); 

table=char(table,str_tablehead); 


% row loop
for i=1:n_rows; 
      
    t_r=[]; 
    % column loop 
    for j=1:n_cols; 
          
        if (Idx_bold(i,j) == 1) 
            t_r=[t_r '\textbf{' num2str(mat(i,j),'%2.3f') '}']; 
        else; 
            t_r=[t_r num2str(mat(i,j),'%2.3f') ]; 
        end; 

		if (any(j == int_vspaces))
			t_r=[t_r ' & '];
        end
		        
		if (j < n_cols)
			t_r=[t_r ' & '];
		else
			t_r=[t_r  ' \\ ' ];
		end
	
    end;
	
    
	t_r=[char(cellstr_column_names2(i,1)) ' & ' t_r]; 
    
	if (i==n_rows)||(any(i==int_hlines)) 
	    t_r=[t_r ' \hline ']; 
    end
    
	table=char(table,t_r); 
        
end;


t_r='\end{tabular}';
table=char(table,t_r); 

t_r='\begin{tablenotes} \footnotesize \itemsep 0pt \item \noindent \emph{Note}:';
table=char(table,t_r); 
table=char(table,str_tablenote); 
table=char(table,'\end{tablenotes}');

if (sideways == 1)
    table_end='\end{sidewaystable}';
else
    table_end='\end{table}';
end


table=char(table, table_end );

  
% -----------------------------------------------------------------------
% SAVE TABLE TO TEX FILE: 

if ischar(str_filename)&&(length(str_filename)>0)

	n2=size(table,1);
	fid=fopen(str_filename,'w');
	  
	for i=1:n2; 
		fprintf(fid,'%s',table(i,:)); 
	end; 
	fclose(fid);

end


