function [A_0,A,M]=getvarma_mat(gammma,R,r,K,p,q); 
% {A_0,A,M}=getvarma_mat(gammma,R,r,K,p,q) transforms
% the parameter vector gamma in the equation
%
%       beta=vec [I-A_0 : A : M]=R gammma + r  
%
% to the matrices A_0, A and M. 
%
% INPUTS: 
%          gammma   (n1 x 1)    Matrix of free parameters
%          R        (n2 x n1)   Restriction matrices
%          r        (n2 x n1)    
%          K        1 x 1       Dimension of the series
%          p        1 x 1       AR - order
%          q        1 x 1       MA - order
%
%  OUTPUTS:
%
%          A_0      K x K       
%          A        K x pK      
%          M        K x qK      
%


beta=R*gammma+r;

r_beta=size(beta,1);


if r_beta>0; 

    nAR1=((K^2)+1);
    nAR2=nAR1+p*(K^2)-1;

    A_0=beta(1:(K^2),:);

    A_0=-reshape(A_0,K,K)+eye(K);

    if nAR2 >= nAR1; 
        A=beta(nAR1:nAR2,:);
        A=reshape(A,K,p*(K));
    else; 
        A=[]; 
    end; 


    if (nAR2+1) <= r_beta; 
        M=beta(nAR2+1:r_beta,:);
        M=reshape(M,K,q*(K));
    else; 
        M=[]; 
    end; 
    
else; 
    A_0=eye(K); 
    A=[];
    M=[]; 
end; 




