function [system_mat,ci_v,yield_data,dates]=get_US_config_new(inputdir)
	
    % System mat has been extended for univariate and all further
    % bivariate and three-dimensional systems
    % The first 8 systems are the main ones of our paper
    
	system_mat={
        [1 2];
        [1 3];
        [1 4];
        [1 5];
        [1 2 3];
        [3 4 5];
        [1 3 5]; 
        [1 2 3 4 5];
        [2 3];
        [2 4];
        [2 5];
        [3 4];
        [3 5];
        [4 5];
        [1 2 4];
        [1 2 5];
        [1 3 4];
        [1 4 5];
        [2 3 4];
        [2 3 5];
        [2 4 5];
        [1];
        [2];
        [3];
        [4];
        [5]
        };
   
    ci_v=[1;
		1;
		1;
		1;
		2;
		2;
		2;
		4;
        0;
        0;
        0;
        0;
        0;
        1;
        1;
        1;
        1;
        1;
        1;
        2;
        2;
        2;
        2;
        2;
        2;
        2]; 


				

 
    % Sheet 3 contains the updated data
    
    filename=[inputdir 'USdata.xls']; 
    sheet='Sheet3'; 
	
	[raw_data,raw_txt]=xlsread(filename,sheet);%,range);%,'basic');
		

	% yields
	raw_data=raw_data(1:end,1:end); 
	yield_data=100*log(1+raw_data/100); 
	
	% dates: 
	dates=raw_txt(2:end,1);
	dates=datevec(dates);
	dates=dates(:,1)+dates(:,2)/12; 
	

	
    

	
	
			
	