function [R,r]=fma_restrictions(K,p,q)
% 	[R,r]=fma_restrictions(K,p,q)
% 	computes the restriction matrices for 
% 	a VARMA(p,q) in Final Moving Average form:
%
%  	y_t = A_1 y_(t-1)+ ... + u_t - m_1 u_(t-1)- ... - m_q u_(t-q) 
%
%  	Restriction matrices are constructed as
%  	in Lktepohl 2005, i.e.
%
%  (alfa_0     
%   beta )     = vec [I-A_0 : A : M]
%
%   (alfa_0
%    beta )    = R gamma + r
%
%   INPUT:
%          K   1 x 1   Dimension of Series
%          p   1 x 1   AR - Order
%          q   1 x 1   MA - Order
%
%   OUTPUT:
%          R   ((p+1+q)*K^2) x (p*K^2+q) = # parameters x # free parameters  
%          r   ((p+1+q)*K^2) x 1 
%                      ... as above

    
    numb_ma_para=q*(K^2);
    numb_totalpara=(p+1)*(K^2)+numb_ma_para;
    
    numb_free_para=p*(K^2)+q; 

  
    if numb_free_para>0;
        
        if (p>0)&(q>0);

            R=[zeros((K^2),(q+p*(K^2))); [eye(p*(K^2)) zeros(p*(K^2),q)]];
            
            R=[R ; kron([zeros(q,p*(K^2)) eye(q)],vec(eye(K))) ];

        elseif p==0;

             R=zeros((K^2),q);
             
             R=[R;kron(eye(q),vec(eye(K)))];
             %R=kron([R;eye(q)],vec(eye(K)));
        
        elseif q==0; 

            R=[zeros((K^2),(q+p*(K^2)));eye(p*(K^2))];
           
        end; 

        r=zeros((numb_totalpara),1);
		
    else; 
        R=[]; 
        r=[]; 
    end; 

