function varma_obj=estimate_var(data,foptions)
% Estimation of VECM
%
%      DY = PI Y_t-1 + GAMMA X + U 
%
%
%
% INPUT: 
%	y   ( K x T )       series
%   p   ( 1 x 1 )       lag length in levels
%   mu  ( 1 x 1 )       intercept dummy:
%                          0 - no intercept 1 - unrestr. intercept
%
% Outputs: 
%	varma_obj
%        
%       .mu
%       .A
%       .res
%       .cov
%

% ESTIMATION CHECKED!! 

[T,K]=size(data); 
if K>=T; error('data has to be of dimension (T x K)'); end; 

y=data'; 


p=foptions.LagOrder; 
mu=foptions.InterceptDummy; 
minp=foptions.minp;
maxp=foptions.maxp; 

if isempty(maxp)
	maxp=floor(sqrt(T/log(T)));
end

if (mu>0)
    D=1; 
else
    D=0;
end



if ischar(p)

	[aic,aic_p,hq,hq_p,sc,sc_p]=order_var(y,D,minp,maxp);
	switch p
		case{'aic'}
			p=aic_p;
		case{'hq'}
			p=hq_p;
		case{'sc'}
			p=sc_p; 
		otherwise
			error('invalid information criteria');
	end
end


%----------------------------------------------------------
% CREATE REGRESSOR MATRICES: 

yr=y(:,p+1:T);

if (p ~= 0)

    X=zeros(K*p,T-p);

    for t=1:(T-p);
        xx=y(:,t:(t+p-1));
        xx=(flipud(xx'))';
        xx=vec(xx);
        X(:,t)=xx;
    end;

else; 
	X=[];  
end;

if (mu==1)
    X=[ones(1,T-p);
		X];    
end

%Z = kron(X',eye(K));

%----------------------------------------------------------
% OLS REGRESSION: 

A_hat = (yr*X')/(X*X');

u_hat = yr - A_hat*X;

CovM_hat=u_hat*(u_hat')/size(u_hat,2); 
u_hat=[nan(K,p) u_hat];



if mu==0;
    
    mu_hat=zeros(K,1); 

elseif mu==1; 
    
    mu_hat=A_hat(:,1); 
    A_hat=A_hat(:,2:end); 
end; 



varma_obj.data=data; 
varma_obj.res=u_hat;
varma_obj.CovM=CovM_hat; 
varma_obj.mu=mu_hat; 
varma_obj.A_0=eye(K); 
varma_obj.A=A_hat; 
varma_obj.M=[]; 

























