function beta = estimate_dl(data,lambda,maturities);
% beta = dlmodel(y,lambda,maturities,T_s)
% estimates factors of Diebold-Li model.
% 
% inputs: 	
%	data			numeric, data vector (T x M) 
%   lambda          fixed scalar parameter
%   maturities      numeric, vector of maturities (M x 1)
%   
% outputs: 
%	beta			estimated coefficients (T x 3)


if isa(data,'double')==0; 
	error('dimodel: input must be double');
end; 

[T,M]=size(data); 

% -------------------------------------------------------------------------
% Generation or regressor matrix and dependent vector

x1=[];
x2=[];
for m = 1:M;
    x1 = [x1;(1-exp(-lambda*maturities(m)))/(lambda*maturities(m))];
    x2 = [x2;((1-exp(-lambda*maturities(m)))/(lambda*maturities(m))) ...
          - exp(-lambda*maturities(m))];
end;

X = [ones(M,1), x1, x2];
Xs = kron(eye(T), X);

ys = vec(data');

% -------------------------------------------------------------------------
% Estimation of time-dependent factors for all time periods

beta= (Xs'*Xs)\(Xs'*ys);

beta = reshape(beta,3,T)';










 