function varma_obj=estimate_civarma_poskitt(data,foptions);
%  usage: varma_obj=estimate_civarma_poskitt(data,foptions);
%
%  Estimate a cointegrated VARMA model using the methodology in Poskitt, (2003)
%  " .... "  
%
% Inputs:
%   data (T x K)                    data
%   foptions                        estimation options. structure.
%									required fields: 
%									.CointOrder: 0,1,...,K 
%									.LagOrder:
%										
%
%									.Identification: 
%										string:
%										fma 	final moving average form
%										rec		reverse Echelon form 	
% Outputs: 
%	varma_obj
%	
%		.beta    	( r*(K-r) x 1 ) corresponds to vec(beta_star ' )  
%     	.alfa    	(K x r)         alfa matrix
%		.gamma   	(dim x 1)       free paramters in vec(G M)
% 
% Calls: 
%   ...
%

% Verify correct number of arguments
error(nargchk(0,2,nargin));



[T,K]=size(data); 
if K>=T; error('data has to be of dimension (T x K)'); end; 
if(sum(sum(isnan(data))) > 0)
    error('data contains NaNs');
end


r=foptions.CointOrder;

y=data';   
mean_y=mean(y')';
yma=y-kron(ones(1,T),mean_y);



%% Specification and estimation: 

% Specify lag order and form restriction matrices accordingly: 
[hT,p,q,R1,r1,R2,r2]=civarma_specify(yma,foptions);

% Estimation of long VAR: 
%[Pi_hT,u_hT]=longVAR(yma,dyma,hT);
D=0; % - no intercept 
longVARobj=var_ols(yma,D,hT);
u_hat_hT=longVARobj.res; 


% GLS estimation: 
[alfa_hat,beta_hat,gamma_2_hat,u_hat,CovM_hat]=civarma_poskitt_step(yma,u_hat_hT,hT,R1,r1,R2,r2,p,q,r); 




%% Save everything in VARMA object: 

% get levels varma representation: 
[A0_hat,A_hat,M_hat]=civarma2varma(alfa_hat,beta_hat,gamma_2_hat,R2,r2,K,(p-1),q);

if (size(beta_hat,1) ~= 0)
    rho_hat=(beta_hat')*mean_y; 
    mu_hat=alfa_hat*(-rho_hat); 
else
    mu_hat=mean_y; 
end
%[A0_hat A_hat M_hat mu_hat alfa_hat beta_hat]

varma_obj.data=data; 
varma_obj.res=u_hat;
varma_obj.CovM=CovM_hat; 
varma_obj.mu=mu_hat; 
varma_obj.A_0=A0_hat; 
varma_obj.A=A_hat; 
varma_obj.M=M_hat; 
varma_obj.beta=beta_hat;
varma_obj.alfa=alfa_hat;
varma_obj.gamma=gamma_2_hat;


























