function dl_frcst = dl_forecast(beta_frcst,lambda,maturities)

% dl_frcst = dl_forecast(beta,h_max)
% Makes direct forecasts of y_t based on AR(1) model
% for Diebold-Li model.
% 
% inputs: 	
%	beta_frcst		forecasted coefficients, array (T x h_max x 3)
%   lambda          fixed scalar parameter
%   maturities      numeric, vector of maturities (M x 1)
%     
% outputs: 
%	dl_frcst		forecasted values, array (T x h_max x maturities)


[T,h_max,K]=size(beta_frcst);
[M,~] = size(maturities);
dl_frcst=nan(T,h_max,M);


% -------------------------------------------------------------------------
% Generation or regressor matrix 

x1=[];
x2=[];
for m = 1:M;
    x1 = [x1;(1-exp(-lambda*maturities(m)))/(lambda*maturities(m))];
    x2 = [x2;(1-exp(-lambda*maturities(m)))/(lambda*maturities(m)) ...
          - exp(-lambda*maturities(m))];
end;

X = [ones(M,1), x1, x2];


% -------------------------------------------------------------------------
% Computing forecasts
% At each ti the forecast for the successive time points are stored.
% E.g. dl_frcst(ti,1,2) is the one-step ahead forecast for the 6M-rate
% for ti+1 made at ti.

for ti = 1:T;
    dl_frcst(ti,:,:) = squeeze(beta_frcst(ti,:,:))*X';
end





