function distance=dist_IR(IR_1,IR_2)
%
%
%
% Depends on: 
%   vec

[K2_1,h_1]=size(IR_1);
[K2_2,h_2]=size(IR_2);

if (K2_1 ~= K2_2)||(h_1 ~= h_2)
    error('dist_IR: impulse response matrices must have same dimension');
end

distance=nan(1,h_1);

for h=1:h_1;
    
    d = vec(IR_1(:,h))-vec(IR_2(:,h)); 
    distance(h) = (d')*d; 

end






