function dy=diff_ts(y,diff_order)
%
% Inputs: 
%   y (T x K)               time series
%   diff_order (1 x 1)      lag order

if nargin<2;
	diff_order=1;
end;
 
[T,K]=size(y); 
 
dy=zeros(T,K); 

if numel(diff_order)==1; 
    dy=diff(y,diff_order);  
else; 
    dmax=max(dVAR);
    for k=1:K;
        if dVAR(k)>0; 
            dy(:,k)=[nan(dVAR(k),1);
            diff(y(:,k),dVAR(k))];
        else; 
            dy(:,k)=y(:,k);
        end;  
    end;     
    dy=dy((dmax+1):end,:);
end;
    

	
	
	
	


	