function dy=diff2(y,diff_order)
% dy=diff2(y,diff_order)
% 	Compute differences of columns of y acc. 2 diff_order
%
% Inputs:
%	y (T x K)
% 	diff_order (1 x 1)
%
% Outputs:
% 	dy (T x K) 

if nargin<2;
	diff_order=1;
end;
 
[T,K]=size(y); 
 
dy=zeros(T,K); 

if numel(diff_order)==1; 
	if (diff_order>0)
		dy=diff(y,diff_order);  
	elseif (diff_order==0)
		dy=y;
	end
else; 
    dmax=max(diff_order);
    for k=1:K;
        if (diff_order(k)>0) 
            dy(:,k)=[nan(diff_order(k),1);
            diff(y(:,k),diff_order(k))];
        elseif (diff_order(k)==0) 
            dy(:,k)=y(:,k);
        end;  
    end;     
    dy=dy((dmax+1):end,:);
end;
    

	
	
	
	


	