function [h_T,p,q,R1,r1,R2,r2] = civarma_specify(y,foptions) 


[K,T]=size(y); 
if K>=T; error('y has to be of dimension (K x T)'); end; 

pq=foptions.LagOrder; 


h_T=floor(log(T)^(1.25));
nu=0.5; 


switch foptions.Identification

    case{'fma'}
        if ischar(pq)

            minp=foptions.minp;
            maxp=h_T;%foptions.maxp; 
            minq=foptions.minq;
            maxq=h_T;%foptions.maxq; 

            m=max([maxp maxq]); 
            h_T=max([m h_T]); 

            switch pq
                case{'dp'}
                    [crit_mat,crit_p,crit_q]=ord_varma_fma(y,minp,maxp,minq,maxq,h_T,nu);
                    pq=[crit_p;
                        crit_q]; 	
                otherwise
                    error('invalid information criteria');
            end
        else
            m=max(pq); h_T=max([m h_T]);
        end

        if (numel(pq) == 2)
            p=pq(1);
            q=pq(2); 
        else
            error('foptions.LagOrder must contain 2 integers');
        end

        % determine restriction matrices: 
        [R1,r1,R2,r2]=civarma_fma_restrictions(K,p-1,q);

    case{'rec'}
        
        if ischar(pq)
            
            minKronIdx = zeros(K,1);
            if isfield(foptions,'minKronIdx')
                minKronIdx = foptions.minKronIdx;
            end
            
            switch (pq)
                case 'PL1'
                    KronIdx=estimate_KronIdxPL1(y',minKronIdx);  
                case 'PL2' 
                    KronIdx=estimate_KronIdxPL2(y',minKronIdx); 
                otherwise 
                    error('invalid specifcation strategy'); 
            end
            
        else
            KronIdx=pq;
        end
        
        % check that cointegrating rank and Kronecker indices are
        % consistent: 
        
        minRank=sum((KronIdx == 0)); 
        if(foptions.CointOrder < minRank) 
            error('rank implied by Kronecker indices higher than cointegrating rank');
        end
        
        m=max(KronIdx); 
        
        p=m;
        q=m;       
        h_T=max([(m+1) h_T]); 
        
        % determine restriction matrices: 
        [R1,r1,R2,r2]=civarma_rec_restrictions(KronIdx); 

        
    otherwise
        error('invalid identification form');     
end






