function [alfa_hat,beta_hat,gamma_2_hat,u_hat,CovM_hat]=civarma_poskitt_step(y,u_hat_hT,h_T,R1,r1,R2,r2,p,q,r)
% Gegeben die Residuen, wird alfa vorgeschaetzt und ein neuer 
% Schaetzer fuer die Kovarianz der Residuen berechnet.  


    [K,T]=size(y);
	if K>=T; error('data has to be of dimension (K x T)'); end; 
    
    dy=nan(K,T); 
    dy(:,2:T)=diff(y')';  
    
    k=p-1; 
    
    if (k==-1)&&(q==0)

        alfa_hat=[];  
        beta_hat=[];
        gamma_2_hat=[]; 
        u_hat=y; 
        CovM_hat=y*(y')/T; 
        
        return; 
        
    end;
% ---------------------------------------------------------------

    
    m=max([k;q]);
    mpq=max([p;q]); 
    
    
    Sigma_u_hT=nancov(u_hat_hT');   % correspond to division by (T-h_T) as in Poskitt (2003)
    iSigma_u_hT=inv(Sigma_u_hT); 
    
    XiSigmaX=0;
    XpinvSigmaDeltay=0; 


    if (m == 0)
        Z_hT=0; 
    else
        Z_hT=nan((k+1+q)*K,T); 	
    end
    z=nan(K,T); 
        
    
    for t=(h_T+1+mpq):T; 

        if (m == 0)
            
            X_t=[kron(y(:,t-1)',eye(K))]*R1; 
            z(:,t)=dy(:,t)-[kron(y(:,t-1)',eye(K))]*r1; 
            
        else
        
            Z_tm1=[]; 
            if (k > 0)
                Z_tm1=flipud(dy(:,t-k:t-1)')';
                Z_tm1=vec(Z_tm1);
            end 

            V_tm1=[]; 
            if q>0;
                V_tm1=flipud(u_hat_hT(:,t-q:t-1)')';
                V_tm1=vec(V_tm1);
            end; 

            Z_hT(:,t-1)=[(dy(:,t)-u_hat_hT(:,t));
                         Z_tm1; 
                         V_tm1];

            X_t=[kron(y(:,t-1)',eye(K)) kron(Z_hT(:,t-1)',eye(K))]*R1; 
            z(:,t)=dy(:,t)-[kron(y(:,t-1)',eye(K)) kron(Z_hT(:,t-1)',eye(K))]*r1; 

        end
        
        XiSigmaX=XiSigmaX+X_t'*iSigma_u_hT*X_t; 
        XpinvSigmaDeltay=XpinvSigmaDeltay+X_t'*iSigma_u_hT*z(:,t); 

    end; 
    
    gamma_1_hat=XiSigmaX\XpinvSigmaDeltay;
   
    % get alfa_hat, beta_hat: 
    
    vec_PiGM=R1*gamma_1_hat+r1; 
    PiGM=reshape(vec_PiGM,K,numel(vec_PiGM)/K); 
        
    Pi_hat=PiGM(:,1:K);
    
%     A_0=-PiGM(:,K+1:2*K)+eye(K);
%     G = GM(2*K+1:(k+2)*K);
%     M = GM((k+2)*K+1 :end); 
    
    GM=0;
    gamma_2_hat=[];
    if (m > 0)
        GM=PiGM(:,(K+1):end); 
        gamma_2_hat=inv(R2'*R2)*(R2')*(vec(GM)-r2);     
    end
        
    
    % get M(1)=M_0+M_1+M_2+...+M_q: 
    if (m > 0)
        M1=-GM(:,1:K)+eye(K); 
    else
        M1=eye(K);
    end
    
        
    if q>0;
        
        M=GM(:,p*K+1:end);
       
        for j=1:q; 
            M1=M1+M(:,(j-1)*K+1:(j*K));  
        end; 
        
    end
    
    
    
    if (r > 0)
        alfa_hat=Pi_hat(:,1:r);

        vec_beta_star_hat=(alfa_hat'*inv(M1*Sigma_u_hT*M1')*alfa_hat)\(alfa_hat'*inv(M1*Sigma_u_hT*M1')*Pi_hat(:,(r+1):K)); 
        
        beta_hat=[eye(r);
                reshape(vec_beta_star_hat,r,K-r)']; 

        % Pi_hat now has reduced rank: 
        Pi_hat=alfa_hat*(beta_hat'); 
    else
        alfa_hat=0;
        beta_hat=0;
        Pi_hat=zeros(K,K);
    end
    
    

    % get residuals 
    u_hat=nan(K,T); 

    if (m > 0)
        for t=(h_T+1+mpq):T;

            u_hat(:,t)=z(:,t)-Pi_hat*y(:,t-1)-GM*Z_hT(:,t-1); 

        end; 
    else
        for t=(h_T+1+mpq):T;

            u_hat(:,t)=z(:,t)-Pi_hat*y(:,t-1); 

        end; 
    end

        
    tmp_u_hat=u_hat;
    tmp_u_hat(isnan(tmp_u_hat))=0;
    CovM_hat=tmp_u_hat*(tmp_u_hat')/size(tmp_u_hat,2);



    

    
        
 
