function [R1,r1,R2,r2]=civarma_fma_restrictions(K,k,q); 
% [R,r,R2,r2]=civarma_fma_restrictions(K,k,q);
%  computes the restriction matrices for 
%  a cointegrated VARMA(p,q) in final ma form:
%
%   Dy_t =  alfa beta' y_(t-1) + G_1 Dy_(t-1) + ...+ G_k Dy_(t-k)
%               +(I-A_0)(y_t-u_t) + M_1 u_(t-1)+...+M_q u_(t-q) 
%               + u_t 
%
%   Restriction matrices are constructed as
%        
%      vec [ (I - A_0) G M] = R2 gamma_2 + r2
%
%      vec [Pi (I - A_0) G M]=R1 gamma_1 + r1
%
%      (Pi = alfa beta' unrestr.)
%
%   INPUT:
%          K   1 x 1   Dimension of Series
%          k   1 x 1   lags in differences
%          q   1 x 1   MA - Order
%


% restrictions for the VAR levels form ([(I-A_0) A M])
[R2,r2]=fma_restrictions(K,k,q); 

R1=blkdiag(eye(K^2),R2); 
r1=[zeros(K^2,1);
    r2]; 






function [R,r]=fma_restrictions(K,p,q)
% 	[R,r]=fma_restrictions(K,p,q)
% 	computes the restriction matrices for 
% 	a VARMA(p,q) in Final Moving Average form:
%
%  	y_t = A_1 y_(t-1)+ ... + u_t + M_1 u_(t-1)- ... + M_q u_(t-q) 
%
%  	Restriction matrices are constructed as
%  	in Lktepohl 2005, i.e.
%
%   vec [(I-A_0), A, M] = R gamma + r
%
%   INPUT:
%          K   1 x 1   Dimension of Series
%          p   1 x 1   AR - Order
%          q   1 x 1   MA - Order
%
%   OUTPUT:
%          R   ((p+1+q)*K^2) x (p*K^2+q) = # parameters x # free parameters  
%          r   ((p+1+q)*K^2) x 1 
%
%   CALLS: 
%           --- 
%

    
    numb_totalpara=(p+1)*(K^2)+q*(K^2);
    numb_free_para=p*(K^2)+q; 

    r=zeros((numb_totalpara),1);

    if (numb_free_para>0)
        
        if (p>0)&&(q>0)

            R=[ zeros((K^2),(q+p*(K^2)));
                [eye(p*(K^2)) zeros(p*(K^2),q)] ];
            R=[ R; 
                kron([zeros(q,p*(K^2)) eye(q)],vec(eye(K))) ];

        elseif (p==0)

             R=zeros((K^2),q);
             R=[R;
                 kron(eye(q),vec(eye(K)))];
        
        elseif (q==0) 

            R=[zeros((K^2),(p*(K^2)));
                eye(p*(K^2))];
           
        end 
	
    else 
        R=[];  
        r=[];
    end 

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    

