function [A_0,A,M]=civarma2varma(alfa_hat,beta_hat,gamma_hat,R,r,K,k,q); 
%   [A_0,A,M]=civarma2varma(alfa_hat,beta_hat,gamma_hat,R,r,K,k,q);
%
%   Converts parameters of a cointegrated EC VARMA representation to 
%   a levels VARMA representation. 
%
%   INPUTS: 
%       alfa_hat  (K x r)
%       beta_hat  (K x r)
%       gamma_hat (* x 1)       vec((I-A_0):G:M) 
%       R                       Restriction matrix 
%       K                       dimension of y 
%       k                       numbers of AR lags in differences
%       q                       numbers of MA lags 
%
%   OUTPUTS: 
%     A_0
%     A
%     M 


% Retrieve A_0, G = [G_1, ..., G_k] and M=[M_1, ..., M_q]
% from  gamma_hat=vec((I-A_0):G:M):

G=[];
M=[];
A_0=eye(K);
         
if (k>0)||(q>0)

        vec_GM=R*gamma_hat+r; 
        GM=reshape(vec_GM,K,K*(k+q+1));

        A_0=-GM(:,1:K)+eye(K);
        GM=GM(:,K+1:end);
        
        if (k>0)&&(q>0);
            G=GM(:,1:k*K); 
            M=GM(:,k*K+1:size(GM,2));
            
        elseif (k==0)&&(q>0); 
            G=[]; 
            M=GM; 
            
        elseif (k>0)&&(q==0); 
            G=GM;
            M=[]; 
            
        end; 
end 
   

% Retrieve the A_i using 
%     Gamma_i   = -(A_(i+1) + ... + A_(i+p))
%     =>A_(i+1) = -(Gamma_i + A_(i+2) + ... + A_(i+p)) 
%               = -(Gamma_i - Gamma_(i+1))
% 
%     Pi        = A_1+...+A_p - A_0 
%     =>A_1     = Pi + A_0 - A_2 - ... - A_p
%               = Pi + A_0 + G_1
  
A=[]; 
if (k == 0)

    % A_1 = Pi + A_0 + G_1
    A=alfa_hat*(beta_hat')+A_0; 
    
elseif (k >= 1)
 
    % A_1 = Pi + A_0 + G_1
	if (~isempty(alfa_hat));
			A_1=alfa_hat*(beta_hat')+A_0+G(:,1:K); 
	else
			A_1=A_0+G(:,1:K);
	end
 
	A=A_1; 
    
    if (k >= 2)
 
        % A_(i+1)  = -(Gamma_i - Gamma_(i+1))
        % => A_j   = Gamma_j - Gamma_(j-1) 
        for j=2:k; 
    
                A_j=G(:,((j-1)*K+1):(j)*K)-G(:,((j-2)*K+1):(j-1)*K);     

                A=[A A_j]; 
        end; 

    end; 

   % => A_p = 0  - Gamma_(p-1) 
    A_p=-G(:,((k-1)*K+1):k*K);
    A=[A A_p]; 
   
end

    
    



