function eigMA = calcEigMA(varma_obj)
% eigMA = calcEigMA(varma_obj) 
% Calculate the maximum eigenvalue of the 
% companion matrix to the matrix polynomial
%
% M(z) = M_0 + M_1 z + .. + M_q z 
% 
% INPUTS:
%       varma_obj      
%
% OUTPUTS:
%      	eigMA
%
% CALLS:
%      - 

M=varma_obj.M;
A_0=varma_obj.A_0; 

K=size(M,1);
q=size(M,2)/K;

Mmod=inv(A_0)*M; 

if(q > 1)
    compmat = [-M;
        [eye(K*(q-1)) zeros(K*(q-1),K)]];
else
    compmat = M;
end

eigMA=eig(compmat);




