function eigAR = calcEigAR(varma_obj); 
%
% Calculates the eigenvalues of the matrix 
% polynomial
% 
% A(z) = A_0 - A_1 z - .. - A_p z 
% 
% INPUTS:
%      varma_obj
%
% OUTPUTS:
%      eigAR
%
% CALLS:
%      - 
%

AA0=varma_obj.A_0; 
AA =varma_obj.A; 

K=size(AA0,1);
p=size(AA,2)/K;

AAt=inv(AA0)*AA; 


if (p > 1)
    compmat=[AAt;
	[eye(K*(p-1)) zeros(K*(p-1),K)] ]; 
else
    compmat=AAt;
end


eigAR=eig(compmat);

