function beta_frcst = beta_forecast_iterative(beta,h_max)

% beta_frcst = beta_forecast(beta,h_max)
% Makes direct forecasts of betas based on AR(1) model
% for Diebold-Li model.
% 
% inputs: 	
%	beta			estimated coefficient vector (T x 3) 
%   h_max           scalar, maximal forecast horizon
%   T               number of observations
%     
% outputs: 
%	beta_frcst		forecasted coefficients, array (T x h_max x 3)


[T,K]=size(beta); 
beta_frcst=nan(T,h_max,K);

% -------------------------------------------------------------------------
% (1) Recursive generation or regressor matrix and dependent vector for  
%     all three beta coefficients.
% (2) Estimation of intercept and slope for AR(1) (c,gamma in DiLi)
% (3) Iterative foreacst of beta's based on estimated coefficients
%     Forecast is done for all possible time points. Row t contains
%     forecasted beta's for forecast of y for periods t+1 up to t+h_max.


for ti = 3:T; %(2+s+h)
    beta_vec = [beta(2:ti,1);beta(2:ti,2);beta(2:ti,3)];
    beta_x = [blkdiag(ones(ti-1,1),ones(ti-1,1),ones(ti-1,1)), ... 
              blkdiag(beta(1:ti-1,1),beta(1:ti-1,2),beta(1:ti-1,3))];
    gamma = (beta_x'*beta_x)\(beta_x'*beta_vec);
    for h=1:h_max;
        beta_frcst(ti,h,:) = (eye(3)-diag(gamma(4:6,1).^h))* ((eye(3)-diag(gamma(4:6,1))) ...
                              \ gamma(1:3,1)) + diag(gamma(4:6,1).^h) ...
                              * [beta(ti,1);beta(ti,2);beta(ti,3)];
    end;
end


