function beta_frcst = beta_forecast_direct(beta,h_max)

% beta_frcst = beta_forecast(beta,h_max)
% Makes direct forecasts of betas based on AR(1) model
% for Diebold-Li model.
% 
% inputs: 	
%	beta			estimated coefficient vector (T x 3) 
%   h_max           scalar, maximal forecast horizon
%   T               number of observations
%     
% outputs: 
%	beta_frcst		forecasted coefficients, array (T x h_max x 3)


[T,K]=size(beta); 
beta_frcst=nan(T,h_max,K);

% -------------------------------------------------------------------------
% (1) Recursive generation or regressor matrix and dependent vector for  
%     all three beta coefficients.
% (2) Estimation of intercept and slope for AR(1) based on shifted indices 
%     (c,gamma in DiLi)
% (3) Direct foreacst of beta's based on estimated coefficients
%     Forecast is done for all possible time points. Row t contains
%     forecasted beta's for forecast of y for periods t+1 up to t+h_max.


for h=1:h_max;
    for ti = 2+h:T; %(2+s+h)
        beta_vec = [beta(1+h:ti,1);beta(1+h:ti,2);beta(1+h:ti,3)];
        beta_x1 = [ones(ti-h,1), beta(1:ti-h,1)];
        beta_x2 = [ones(ti-h,1), beta(1:ti-h,2)];
        beta_x3 = [ones(ti-h,1), beta(1:ti-h,3)];
        beta_x = blkdiag(beta_x1,beta_x2,beta_x3);
        gamma = (beta_x'*beta_x)\(beta_x'*beta_vec);
        beta_frcst(ti,h,:) = blkdiag([1, beta(ti,1)],[1, beta(ti,2)],[1, beta(ti,3)])...
                             *gamma;
    end
end


