function results=backtest(frcst_function,name,dates,y,foptions,T_s,h_max); 
% results=backtest(frcst_function,name,dates,y,foptions,T_s,h_max);
% 	
% ... computes the results of a pseudo out-of-sample forecast analysis. 
%
% inputs: 
% 	frcst_function		Forecast procedure to be evaluated 
% 	name 				
% 	dates				Date values (T x 1) 
% 	y					Time series (T x K) 
% 	foptions			Options of forecast procedure
%	T_s					Start of evaluation period
%	h_max				Max. Forecast horizon
%
% outputs:
%	results				structure:
%		.name			"name" of results structure 
% 		.data			
% 		.actuals
% 		.dates
% 		.frcsts_L
% 		.frcsts_D 
% 		.frcsts_DD 
% 		.ferrors 
% 		.tmse			trace MSFE			





[T_bar,K]=size(y);
dVAR=foptions.dVAR; 


% -------------------------------------------------------------------------
% COMPUTE FORECASTS:  

var_frcsts_L=nan(K,h_max,T_bar);    % levels
var_frcsts_D=nan(K,h_max,T_bar);    % 1st differences
var_frcsts_DD=nan(K,h_max,T_bar);   % 2nd differences


for T=T_s:T_bar;
    
%----------------------------------------------------------------------
    % Preliminary data transformations: 
    y_T=y(1:T,:); 
	Dy_T=diff2(y_T,dVAR);
	
%----------------------------------------------------------------------
    % Estimation: 
    fit=feval(frcst_function,Dy_T,foptions); 
    
%----------------------------------------------------------------------
    % Forecasting levels and differences:

    % frcst is in K x h_max 
    [frcstL,frcstD,frcstDD]=varma_frcst_wrapper(y_T,fit,dVAR,h_max); 
	
    var_frcsts_L(:,:,T)=frcstL; 
    var_frcsts_D(:,:,T)=frcstD;   
    var_frcsts_DD(:,:,T)=frcstDD;   
    
end;




% -------------------------------------------------------------------------
%% COMPUTE ACTUALS: 

% actuals is in (T_bar x K):
actuals=diff2(y,dVAR); 


% -------------------------------------------------------------------------
%% COMPUTE FORECAST ERRORS and RMSEs per HORIZON: 

for h=1:h_max; 

    
    frcst_errors=nan(T_bar,K); 

    % forecast variables as they enter the VAR: 
    
    if dVAR==0; 
        frcsts=squeeze(var_frcsts_L(:,h,T_s:(T_bar-h)))';    
    else; 
        frcsts=[]; 
        for k=1:K; 
            if dVAR(k)==0; 
                frcsts(:,k)=squeeze(var_frcsts_L(k,h,T_s:(T_bar-h)));    
            elseif dVAR(k)==1;
                 frcsts(:,k)=squeeze(var_frcsts_D(k,h,T_s:(T_bar-h)));    
            elseif dVAR(k)==2;
                frcsts(:,k)=squeeze(var_frcsts_DD(k,h,T_s:(T_bar-h)));    
            end;
        end; 
    end; 
        
    frcst_errors(T_s+h:T_bar,:)=frcsts-actuals(T_s+h:T_bar,:);
    
    rMSFE=(nansum(frcst_errors.^2)/(T_bar-T_s-h))./nanvar(actuals(T_s+h:T_bar,:));

    trace_mse(h)=mean(rMSFE); 

    ferror_array(:,:,h)=frcst_errors;  
    
end;




% Save name, frcsts, errors, MSE, trace MSE,...
results.name=name;
results.data=y;
results.actuals=actuals;
results.dates=dates;

results.frcsts_L=var_frcsts_L;
results.frcsts_D=var_frcsts_D; 
results.frcsts_DD=var_frcsts_DD; 
results.ferrors=ferror_array; 
results.tmse=trace_mse;


































