% tests.m
% Program to test programs implementing Poskitt and Ltkepohl's (1995)
% proposed specification algorithms. 
% The DGPs in the paper of Bartel and Ltkepohl (1997) are used. 

clear; 
addpath('../'); 
dbstop if error

% ---------------------------------------------------------------------
% MC parameters

T=150; 
N=200; 
int_dgp=10;

% ---------------------------------------------------------------------
% MC replications 

VARMAmodel=setVARMAparameters(int_dgp);
K=size(VARMAmodel.A_0,1); 

PL1idx=zeros(N,K);
PL2idx=zeros(N,K); 

minKronIdx=zeros(K,1); 

dbstop in estimate_pk at 23;

for n=1:N;

	[ts_data,ts_errors]=simulateVARMAmodel(VARMAmodel,T); 
	
	kron_idx=estimate_KronIdxPL1(ts_data,minKronIdx);
	PL1idx(n,:)=kron_idx'; 
	
% 	kron_idx=estimate_KronIdxPL2(ts_data,minKronIdx);
% 	PL2idx(n,:)=kron_idx'; 

end;

% ---------------------------------------------------------------------
% Summary of results:

disp('Relative frequencies of estimated Kronecker indices');
% disp('(Table 6 in BL)');
T
disp('....');
disp('PL1:');
PL1_results=countFreqCategories(PL1idx);
PL1_results.Categories
PL1_results.RelFreq
% disp('PL2:');
% PL2_results=countFreqCategories(PL2idx);
% PL2_results.Categories
% PL2_results.RelFreq










 







