function [D,foptions]=setoptions_KronIdx(y,design); 

[T,K]=size(y); 



switch (design)
    
    case 1
        
        D=1; 
        maxp=round(1.5*(log(T)^(1))); 
        [aic,aic_p,hq,hq_p,sc,sc_p]=order_var(y',D,0,maxp);

        h_T=max([aic_p;4]); 
        P_T=round(0.5*h_T); 
        C_T=(h_T*log(T)); 

   
        
    case 4
        
        D=1; 
        maxp=round(1.5*(log(T)^(1))); 
        [aic,aic_p,hq,hq_p,sc,sc_p]=order_var(y',D,0,maxp);
        
        h_T=max([aic_p;floor(log(T));4]); 
        P_T=round(0.5*h_T); 
        C_T=(h_T^2); 

        
    otherwise
        error('no valid design specified');
end

foptions.h_T=h_T;
foptions.P_T=P_T;
foptions.C_T=C_T;
