function [R,r]=rec_restrictions(p)
% [R,r]=REC_restrictions(p)computes the restriction 
% matrices for a K-dimensional VARMA(p1,p2,..pK) in Echelon form:
%
%  A_0 y_t = A_1 y_(t-1)+ ... + ...+ A_0 u_t + ... M_q u_(t-q) 
%
%  Restriction matrices are constructed as in Lktepohl 2005, 
%  such that 
%
%   vec [(I - A_0), A, M] = R gamma + r
%
%   INPUT:
%          p (K x 1)    Vector of Kronecker Indices
%
%   OUTPUT:
%          R            Restriction matrices  
%          r            as defined above with 
%                       R (# total parameters x # free paramters)
%                       r (# total paramters x 1) 
%
%   CALLS:
%           - - - 
%

if (~isvector(p))
    error('REC_restrictions: Input has to be a vector'); 
end

KK=numel(p);
maxp=max(p);


% computation of pki_mat:
pkimat=zeros(KK,KK);
for k=1:KK;
    for i=1:KK;

        if (k >= i)
            pkimat(k,i)=min([(p(k)+1);p(i)]);
        else;
            pkimat(k,i)=min([(p(k));p(i)]);  
        end;

    end
end


%% Formulation of 0-1 restriction matrix 
% with the same dimensions and order as
%
%   [ A_1, A_2, ...., A_p, I_K - M_0, M_1, ...., M_q] 
%
% (A_0 == M_0) 


% AR - Part: 
AA=[];
for j=1:maxp;
    
    AAj=zeros(KK,KK);

    for k=1:KK; % loop over rows of A_p 
        
        if (j <= p(k))
           AAj(k,:)=ones(1,KK);             
        end
        
    end
    
    AA=[AA AAj];
  
end


% MA - Part: 
MM=[];
for j=0:maxp;   % loop over lags 

    MMj=zeros(KK,KK);
    
    for k=1:KK; % loop over rows of M_j
        
        for i=1:KK; % loop over columns of M_j

            % Diagonal Elements:
            if (k==i)
                if j==0;
                    MMj(k,i)=0;
                elseif (j ~= 0)&&(j <= p(k));            
                    MMj(k,i)=1;
                end;
                
            % Off-Diagonals:
            else
                if (j >= (p(k)-pkimat(k,i)+1)) && (j <= p(k));
                    MMj(k,i)=1;
                end;
            end

        end;
    end;

    MM=[MM MMj];

end

%% Reordering of 0-1 restriction matrix 
% such that order is now
%
%   [(I_K - M_0), A_1, A_2, ...., A_p, M_1, ...., M_q] 
%
% (A_0 == M_0) 

AAMM=[MM(:,1:KK) AA MM(:,KK+1:end)];

AAMM=vec(AAMM);


%% Making R and r: 
numbfreeparam=sum(AAMM);

numbparam=2*maxp*(KK^2)+KK^2;

lauf=1;
R=zeros(numbparam,numbfreeparam);
for i=1:numbparam;
    if (AAMM(i) ~= 0);
        R(i,lauf)=1;
        lauf=lauf+1;
    end;
end

r=zeros((numbparam),1);








