function sigma2_kT=get_sigma2_kT2(y,u_hat,s_T,SearchIdx,KronIdxPL2,k,n)
%
%
% Inputs: 
%   y (T x K)       time series
%   u_hat (T x K)     u_hatiduals from long VAR  
%   s_T (1 x 1)     
%	SearchIdx ....
%   k (1 x 1)       indx of series
%   n (1 x 1)       lag order 


[T,K]=size(y); 

y_k=y(:,k); 
y_e=y-u_hat; 


% get the set {k(q+1),...,k(K)}
	AllIdx = 1:K; 
    FixedIdx=setdiff(AllIdx,SearchIdx);
    % 	idx = ~isnan(KronIdxPL2); 
% 	fixed_k = AllIndx(idx); 


% get (y_jt - u_jt) j ne k and j ne {k(q+1),...,k(K)}
    idx=setdiff((1:K),k);
	idx=setdiff(idx,FixedIdx); 
    
	X=[ones(T,1)]; 
	for j = idx; 
        X = [X y_e(:,j)]; 
	end;


% get u_k(j),(t-s)  for j = (q+1), ...,K; s = (n-p_k(j)), ..., n 
	for k_j = FixedIdx; 

		p_k_j = KronIdxPL2(k_j); 
		
		for s = (n-p_k_j):n;
		
			X = [X [nan(s,1);u_hat(1:(T-s),k_j)] ]; 

		end; 	

	end; 


% get y_(t-s), s=1,...,n
	for s=1:n; 
	
		X = [X [nan(s,K);y(1:(T-s),:)] ]; 
	
	end; 
	
% get u_j,(t-s) j ~in {k(q+1),...,k(K)}  , s=1,...,n

	for j = SearchIdx; 
	
		for s=1:n; 
			X = [X [nan(s,1);u_hat(1:(T-s),j)]]; 
		end; 
	
	end; 


% do the actual regu_hatsion
	y_k=y_k(s_T+1:T,:); 
	X=X(s_T+1:T,:);

	u_hat_k=y_k-X*inv(X'*X)*X'*y_k; 

	sigma2_kT=(u_hat_k')*u_hat_k/T; 



	








