function sigma2_kT=get_sigma2_kT(y,res,k,s_T,n)
%
%
% Inputs: 
%   y (T x K)       time series
%   res (T x K)     residuals from long VAR  
%   k (1 x 1)       indx of series
%   s_T (1 x 1)     
%   n (1 x 1)       lag order 

%-----------------------------------------------------------
% check inputs
[T,K]=size(y); 

if (K>=T)
	error('get_sigma2_kT: y has to be in (T x K)');
end

%-----------------------------------------------------------
% form regressand and regressors
y_k=y(:,k); 

y_e=y-res; 
idx=((1:K)~=k);
y_e=y_e(:,idx);

Z=[];
if (n > 0)
	y_res=[y res]; 
	for s=1:n; 
	   Z=[ Z [nan(s,2*K); y_res(1:(end-s),:)] ];  
	end
end
X=[ones(T,1) y_e Z];


y_k=y_k(s_T+1:T,:); 
X=X(s_T+1:T,:);

res_k=y_k-X*inv(X'*X)*X'*y_k; 

sigma2_kT=(res_k')*res_k/(T-s_T); 











