function pk=estimate_pk(y,res,k,foptions,min_pk)

T=size(y,1); 

h_T=foptions.h_T;
P_T=foptions.P_T;
C_T=foptions.C_T; 
s_T=h_T+P_T; 


sigma2_kT=nan(P_T+1,1); 
Delta_kT=nan(P_T+1,1); 

for n=0:P_T; 
    
    sigma2_kT(n+1)=get_sigma2_kT(y,res,k,s_T,n); 
    Delta_kT(n+1)=log(sigma2_kT(n+1))+(C_T*n)/(T-s_T);
   
end; 

[min_value,min_idx]=min(Delta_kT((min_pk+1):end,:)); 

pk=min_idx-1+min_pk; 






