function KronIdx=estimate_KronIdxPL2(y,minKronIdx) 
% estimate_KronIdxPL2 
% estimates the Kroneker Indices of a VARMA model using 
% the modified "stage II' " method as proposed in 
%
% Poskitt and Ltkepohl (1995): Consistent Specification of Cointegrated
% Autoregressive Moving-Average Systems, Working Paper	
%
% Poskitt (2003): On the specification of cointegrated autoregressive 
% moving-average forecasting systems; International Journal of Forecasting;



% ----------------------------------------------------
% check inputs

[T,K]=size(y); 
if (K >= T)
	error('y has to be of dimension (T x K)');
end


% ----------------------------------------------------
% set options 

[D,foptions]=setoptions_KronIdx(y,4); 

% ----------------------------------------------------
% estimation of Kronecker indices 

long_var=var_ols(y',D,foptions.h_T);
res=long_var.res'; 

% initialize: 

KronIdxPL1 = estimate_KronIdxPL1(y,minKronIdx);
KronIdxPL2 = nan(K,1); 
SearchIdx  = 1:K;


[p_k_K,k_K]=min(KronIdxPL1); 
KronIdxPL2(k_K)=p_k_K; 
SearchIdx=setdiff(SearchIdx,k_K); 
p_k_qp1=p_k_K; 


s_T=foptions.P_T+foptions.h_T; 
C_T=foptions.C_T; 
for q = (K-1):(-1):1; 

	DeltaArgMin=nan(K,1); 
	
	for k = SearchIdx;
	
		sigma2_kT = nan(foptions.P_T+1,1);
		Delta_k   = nan(foptions.P_T+1,1); 
		
		for n = p_k_qp1:foptions.P_T; 
		
			sigma2_kT(n+1) = get_sigma2_kT2(y,res,s_T,SearchIdx,KronIdxPL2,k,n); 
			Delta_k(n+1)= log(sigma2_kT(n+1))+(C_T*n)/(T);
		
        end

        min_pk=minKronIdx(k); 
        
		[tmp_min,tmp_idx]=min(Delta_k((min_pk+1):end,:));  	
		DeltaArgMin(k)=tmp_idx-1+min_pk; 
		
	end 
	
	[p_k_q,k_q] = min(DeltaArgMin); 
		
	KronIdxPL2(k_q)=p_k_q; 
	p_k_qp1=p_k_q; 
	SearchIdx=setdiff(SearchIdx,k_q); 
	
end; 

KronIdx=KronIdxPL2;










