function KronIdx=estimate_KronIdxPL1(y,minKronIdx) 
% estimate_KronIdxPL1 estimates the Kroneker Indices of an 
% applied VARMA model using the methods proposed in 
%
% Poskitt (2003): On the specification of cointegrated autoregressive 
% moving-average forecasting systems; International Journal of Forecasting;
% 19; pp. 503-519 
%

% ----------------------------------------------------
% check inputs

[T,K]=size(y); 
if (K >= T)
	error('y has to be of dimension (T x K)');
end


% ----------------------------------------------------
% set options 

[D,foptions]=setoptions_KronIdx(y,4); 


% ----------------------------------------------------
% estimation of Kronecker indices 

long_var=var_ols(y',D,foptions.h_T);
res=long_var.res'; 

KronIdx=zeros(K,1); 
for k=1:K; 
   
    min_pk=minKronIdx(k); 
    
    KronIdx(k)=estimate_pk(y,res,k,foptions,min_pk); 
    
end;












