function count_mat=countFreqCategories(NumMat); 
% 
%
% OUTPUT: 
%   count_mat.Categories
%   count_mat.RelFreq


[m,n,d]=size(NumMat); 


Categories=NumMat(1,:,1); 

for d_idx = 1:d; 

    for r_idx = 1:m;
     
        row_r=NumMat(r_idx,:,d_idx);
	
        if ~ismember(Categories,row_r,'rows');
            Categories=[Categories;row_r];
        end; 
	end; 
end
   

Categories=sortrows(Categories); 

num_cat=size(Categories,1); 


for d_idx = 1:d; 

    for c_idx=1:num_cat; 

        absFreq=0; 
        categorie=Categories(c_idx,:); 

        for r_idx=1:m; 

            row_r=NumMat(r_idx,:,d_idx); 

            if ismember(categorie,row_r,'rows'); 
                absFreq=absFreq+1; 
            end; 

        end; 

        RelFreq(c_idx,d_idx)=absFreq/m; 

    end;

end

count_mat.Categories=Categories; 
count_mat.RelFreq=RelFreq;







