function [R1,r1,R2,r2]=civarma_rec_restrictions(p)
% [R1,r1,R2,r2]=civarma_rec_restrictions(p)
% computes the restriction matrices for a K-dimensional 
% VARMA(p1,p2,..pK) in Error Correction - Echelon form.
%
%   INPUT:
%          p (K x 1)    Vector of Kronecker Indices
%


if (~isvector(p))
    error('REC_restrictions: Input has to be a vector'); 
end

K=numel(p);
maxp=max(p);


% computation of pki_mat:
pkimat=zeros(K,K);
for k=1:K;
    for i=1:K;

        if (k >= i)
            pkimat(k,i)=min([(p(k)+1);p(i)]);
        else
            pkimat(k,i)=min([(p(k));p(i)]);  
        end

    end
end


%% Formulation of 0-1 restriction matrix 
% with the same dimensions and order as
%
%   [ A_1, A_2, ...., A_p, I_K - M_0, M_1, ...., M_q] 
%
% (A_0 == M_0) 


% AR - Part: 
AA=[];
for j=1:maxp;
    
    AAj=zeros(K,K);

    for k=1:K; % loop over rows of A_p 
        
        if (j <= p(k))
           AAj(k,:)=nan(1,K);             
        end
        
    end
    
    AA=[AA AAj];
  
end


% MA - Part: 
MM=[];
for j=0:maxp;   % loop over lags 

    MMj=zeros(K,K);
    
    for k=1:K; % loop over rows of M_j
        
        for i=1:K; % loop over columns of M_j

            % Diagonal Elements:
            if (k==i)
                if j==0;
                    MMj(k,i)=0;
                elseif (j ~= 0)&&(j <= p(k));            
                    MMj(k,i)=nan(1);
                end;
                
            % Off-Diagonals:
            else
                if (j >= (p(k)-pkimat(k,i)+1)) && (j <= p(k));
                    MMj(k,i)=nan(1);
                end;
            end

        end;
    end;

    MM=[MM MMj];

end

%% Reordering of 0-1 restriction matrix 
% such that order is now


%   [(I_K - A_0), G_1, G_2, ...., G_(p-1), M_1, ...., M_q] 
AAMM=[MM(:,1:K) AA(:,K+1:end) MM(:,K+1:end)];
[R2,r2]=make_Rr(AAMM); 

% Pi = A_1 + ... + A_p - A_0
mat_Pi= MM(:,1:K)-eye(K);
for j=1:maxp;
   mat_Pi=mat_Pi+AA(:,(j-1)*K+1:j*K); 
end

%   [Pi (I_K - A_0), G_1, G_2, ...., G_(p-1), M_1, ...., M_q] 
AAMM=[mat_Pi MM(:,1:K) AA(:,K+1:end) MM(:,K+1:end)];
[R1,r1]=make_Rr(AAMM); 





function [R,r]=make_Rr(AAMM); 
% Making R and r: 

AAMM=vec(AAMM);
numbfreeparam=sum(isnan(AAMM));
numbparam=numel(AAMM);

r=zeros((numbparam),1);

lauf=1;
R=zeros(numbparam,numbfreeparam);
for i=1:numbparam;
    
    if (isnan(AAMM(i)))
        R(i,lauf)=1;
        lauf=lauf+1; 
    else 
        r(i)=AAMM(i);
    end
    
end

 












