function [RRc,rc,RR,r]=EC_restrictions(p)
% [RRc,rc,RR,r]=EC_restrictions(p)
% computes the restriction matrices for 
% a K-dimensional VARMA(p1,p2,..pK) in Echelon form:
%
%  A_0 y_t = A_1 y_(t-1)+ ... + ...+ A_0 u_t + ... M_q u_(t-q) 
%
%  Restriction matrices are constructed as
%  in Lktepohl 2005, i.e.
%
%  (alfa_0     
%   beta )     = vec [I-A_0 : A : M]
%
%   (alfa_0
%    beta )    = RRc gamma + rc
%
%   and
%
%  (alfa_0     
%   beta )     = vec [A_0 : A : M]
%
%   (alfa_0
%    beta )    = RR gamma + r
%
%
%   INPUT:
%          p   K x 1   Vector of Kronecker Indices
%
%
%   OUTPUT:
%          RRc         Restriction matrices  
%          rc          as defined above.
%          RR  
%          r   
%
%   CALLS:
%           - - - 
%

if (~isvector(p))
    error('EC_restrictions: Input has to be a vector'); 
end

KK=numel(p);
maxp=max(p);


% computation of pki_mat:

pkimat=zeros(KK,KK);

for k=1:KK;
    for i=1:KK;

        if k==i;
            pkimat(k,i)=p(k); 
        elseif k > i;
            pkimat(k,i)=min([(p(k)+1);p(i)]);
        else;
            pkimat(k,i)=min([(p(k));p(i)]);  
        end;

    end
end



% Computation of 
%
%   [I-A_0,  A_1 A_2 .... A_p M_1 .... M_q ] 
%
% by putting 0 and 1 s for restricted
% and unrestricted parameters, respectively.

% AR - Part
AA=[];

for j=0:maxp;

    AAp=zeros(KK,KK);
    
    for k=1:KK;
        
        for i=1:KK;

            % Diagonal Elements:
            if (k==i)
                if j==0;
                    AAp(k,i)=0;
                elseif (j ~= 0)&&(j <= p(k));            
                    AAp(k,i)=1;
                end;
            % Off-Diagonals:
            else
                if (j >= (p(k)-pkimat(k,i)+1)) && (j <= p(k));
                    AAp(k,i)=1;
                end;
            end

        end;
    end;

    AA=[AA AAp];

end


MM=[];
% MA - Part
for j=1:maxp;
    
    MMq=zeros(KK,KK);
    
    for k=1:KK;
    
        for i=1:KK;
            if (j <= p(k));
                MMq(k,i)=1;
            end;
        end
        
    end
    
    MM=[MM MMq];
  
end

% Setting up [I-A_0 : A : M]:

AAMM=[AA MM];

AAMM=vec(AAMM);

% Making RRc:
numbfreeparam=sum(AAMM);
numbparam=2*maxp*(KK^2)+KK^2;

lauf=1;
RRc=zeros(numbparam,numbfreeparam);

for i=1:numbparam;
    if (AAMM(i) ~= 0);
        RRc(i,lauf)=1;
        lauf=lauf+1;
    end;
end

% Making rc:

rc=zeros((numbparam),1);

% Making RR and r:

RR=RRc;
RRc(1:(KK^2),:)=-RRc(1:(KK^2),:); 
r=[vec(eye(KK)); 
    zeros((numbparam-(KK^2)),1)];


%retp(RRc,rc,RR,r);

