% --------------------------------------------------------------------
%{ 
  	make_yield_graph.m:   
  	Make graph of all yields. 

    Replication files for the paper
 
    "Simple Identification and Specification of Cointegrated VARMA
    Models"
  
    by Christian Kascha and Carsten Trenkler. 
    (final version: January, 2014)
%}
% --------------------------------------------------------------------


clear; 
close all; 

% Set paths:
addpath('mfiles'); 
inputdir='data/';
graphicsdir='../text/graphs/';

% Set basic parameters:
h_max=12;
dataset='full'; 
T_s=200; 

% Load data set specifics & data set
switch dataset
	case{'full'}
		[system_mat,ci_v,yield_data,dates]=get_US_config_new(inputdir); 
	otherwise
		error('invalid data set');
end


plot(dates,yield_data(:,1),'Color',[.75,.75,.75])
hold on
plot(dates,yield_data(:,2),'Color',[.5,.5,.5])
plot(dates,yield_data(:,3),'Color',[.4,.4,.4])
plot(dates,yield_data(:,4),'Color',[.25,.25,.25])
plot(dates,yield_data(:,5),'Color',[.15,.15,.15])
hold off

title('US Yields, 3M - 10Y')
set(gca,'FontSize',12)

saveas(gcf,[graphicsdir 'yields.pdf'])












